/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.protocol;

import de.gematik.ti.healthcard.control.entities.card.certificate.CertificateUtil;
import de.gematik.ti.healthcard.control.exceptions.HealthcardControlRuntimeException;
import de.gematik.ti.healthcard.control.protocol.Subscribers;
import de.gematik.ti.healthcardaccess.AbstractHealthCardCommand;
import de.gematik.ti.healthcardaccess.IHealthCard;
import de.gematik.ti.healthcardaccess.IHealthCardStatus;
import de.gematik.ti.healthcardaccess.IHealthCardType;
import de.gematik.ti.healthcardaccess.cardobjects.ApplicationIdentifier;
import de.gematik.ti.healthcardaccess.cardobjects.ShortFileIdentifier;
import de.gematik.ti.healthcardaccess.commands.ReadCommand;
import de.gematik.ti.healthcardaccess.commands.SelectCommand;
import de.gematik.ti.healthcardaccess.healthcards.Hba2;
import de.gematik.ti.healthcardaccess.healthcards.Hba21;
import de.gematik.ti.healthcardaccess.healthcards.HealthCardStatusValid;
import de.gematik.ti.healthcardaccess.healthcards.Smcb2;
import de.gematik.ti.healthcardaccess.healthcards.Smcb21;
import de.gematik.ti.healthcardaccess.operation.ResultOperation;
import de.gematik.ti.healthcardaccess.operation.Subscriber;
import de.gematik.ti.healthcardaccess.result.Response;
import de.gematik.ti.utils.codec.Hex;
import de.gematik.ti.utils.primitives.Bytes;
import java.nio.charset.Charset;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolRecordBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolRecordBuilder.class);
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final int MAXIMUMRECORDLENGTH = 46;

    private ProtocolRecordBuilder() {
    }

    public static byte[] buildRecord(String actorId, String actorName, String dataType, String typeAccess) {
        byte[] timeStampBytes = ProtocolRecordBuilder.getByteArrayOfLongvalue(System.currentTimeMillis() / 1000L);
        return ProtocolRecordBuilder.buildRecord(timeStampBytes, dataType, typeAccess, actorId, actorName);
    }

    public static byte[] buildRecord(byte[] timeStampBytes, String dataType, String typeAccess, String actorId, String actorName) {
        if (timeStampBytes.length != 4) {
            throw new HealthcardControlRuntimeException("Wrong length of 'timestampe': " + timeStampBytes.length);
        }
        byte[] dataTypeBytes = dataType.getBytes(CHARSET);
        if (dataTypeBytes.length != 1) {
            throw new HealthcardControlRuntimeException("Wrong length of 'dataType': " + dataTypeBytes.length);
        }
        byte[] typeAccessBytes = typeAccess.getBytes(CHARSET);
        if (typeAccessBytes.length != 1) {
            throw new HealthcardControlRuntimeException("Wrong length of 'typeAccess': " + typeAccessBytes.length);
        }
        byte[] actorIdBytes = Hex.decode((String)actorId);
        if (actorIdBytes.length != 10) {
            throw new HealthcardControlRuntimeException("Wrong length of 'actorId': " + actorIdBytes.length);
        }
        byte[] actorNameBytes = ProtocolRecordBuilder.padString(actorName, 30);
        if (actorNameBytes.length != 30) {
            throw new HealthcardControlRuntimeException("Wrong length of 'actorName': " + actorNameBytes.length);
        }
        byte[] record = Bytes.concatNullables((byte[][])new byte[][]{timeStampBytes, dataTypeBytes, typeAccessBytes, actorIdBytes, actorNameBytes});
        if (record.length != 46) {
            throw new HealthcardControlRuntimeException("Wrong length of record: " + record.length);
        }
        return record;
    }

    public static byte[] buildRecord(IHealthCard cardHc, String dataType, String typeAccess) {
        String cardClassName = ProtocolRecordBuilder.checkCard(cardHc);
        String actorId = ProtocolRecordBuilder.readIcc(cardHc);
        LOG.debug("actorId: " + actorId);
        String actorName = ProtocolRecordBuilder.readActorNameFromAutCert(cardHc, cardClassName);
        return ProtocolRecordBuilder.buildRecord(actorId, actorName, dataType, typeAccess);
    }

    private static String readActorNameFromAutCert(IHealthCard cardHc, String cardClassName) {
        ApplicationIdentifier aid = new ApplicationIdentifier("A000000167455349474E");
        ShortFileIdentifier sfId = null;
        switch (cardClassName) {
            case "Hba21": {
                sfId = new ShortFileIdentifier(6);
                break;
            }
            case "Hba2": {
                sfId = new ShortFileIdentifier(1);
                break;
            }
            case "Smcb21": {
                sfId = new ShortFileIdentifier(7);
                break;
            }
            case "Smcb2": {
                sfId = new ShortFileIdentifier(16);
                break;
            }
            default: {
                LOG.error("not supported cardtype: " + cardClassName);
            }
        }
        SelectCommand selectESignCommand = new SelectCommand(aid);
        ReadCommand readESignCommand = new ReadCommand(sfId);
        ResultOperation resultOperation = selectESignCommand.executeOn(cardHc).flatMap(arg_0 -> ProtocolRecordBuilder.lambda$readActorNameFromAutCert$0((AbstractHealthCardCommand)readESignCommand, cardHc, arg_0)).map(Response::getResponseData);
        Subscribers.CertificateSubscriber certificateSubscriber = new Subscribers.CertificateSubscriber();
        resultOperation.subscribe((Subscriber)certificateSubscriber);
        byte[] certbytes = certificateSubscriber.getCertificate();
        X509Certificate certificate = CertificateUtil.getCertificate(certbytes);
        switch (cardClassName) {
            case "Hba21": 
            case "Hba2": {
                String surnameGivenname = CertificateUtil.getSurnameGivenname(certificate);
                LOG.trace("certificate: \n" + certificate);
                LOG.debug("surnameGivenname: " + surnameGivenname);
                return surnameGivenname;
            }
            case "Smcb2": 
            case "Smcb21": {
                String commonname = CertificateUtil.getCommonName(certificate);
                LOG.debug("commonname: " + commonname);
                return commonname;
            }
        }
        LOG.error("Unknown cardtype: " + cardClassName);
        throw new HealthcardControlRuntimeException("actorName for cardtype " + cardClassName + " is not available");
    }

    private static String readIcc(IHealthCard cardHc) {
        ResultOperation responseResultOperation = new SelectCommand(false, false).executeOn(cardHc).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).flatMap(__ -> new ReadCommand(ProtocolRecordBuilder.getSfid(cardHc)).executeOn(cardHc)).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).map(Response::getResponseData).flatMap(gdoData -> {
            byte[] bs = Arrays.copyOfRange(gdoData, 2, 12);
            return ResultOperation.unitRo((Object)Hex.encodeHexString((byte[])bs));
        });
        Subscribers.ActorIdSubscriber actorIdSubscriber = new Subscribers.ActorIdSubscriber();
        responseResultOperation.subscribe((Subscriber)actorIdSubscriber);
        return actorIdSubscriber.getActorId();
    }

    private static ShortFileIdentifier getSfid(IHealthCard cardHc) {
        int commonSfid = 2;
        return new ShortFileIdentifier(commonSfid);
    }

    public static byte[] getByteArrayOfLongvalue(long value) {
        if (value == 0L) {
            return new byte[]{0};
        }
        byte[] array = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        while (array.length > 0 && array[0] == 0) {
            array = Bytes.copyByteArray((byte[])array, (int)1, (int)(array.length - 1));
        }
        return array;
    }

    private static byte[] padString(String actorName, int count) {
        byte[] actorNameBytes = actorName.getBytes(CHARSET);
        if (actorName.length() < count) {
            LOG.debug("spaces are added to actorName");
            byte[] bytes = new byte[count];
            Arrays.fill(bytes, (byte)32);
            System.arraycopy(actorNameBytes, 0, bytes, 0, actorNameBytes.length);
            return bytes;
        }
        if (actorName.length() > count) {
            byte[] bytes = new byte[count];
            LOG.debug("actorName is too long, it is shortened");
            System.arraycopy(actorNameBytes, 0, bytes, 0, count);
        }
        return actorNameBytes;
    }

    private static String checkCard(IHealthCard cardHc) {
        IHealthCardStatus hcStatus = cardHc.getStatus();
        if (hcStatus.isValid()) {
            IHealthCardType cardType = ((HealthCardStatusValid)hcStatus).getHealthCardType();
            if (cardType instanceof Hba21) {
                return Hba21.class.getSimpleName();
            }
            if (cardType instanceof Hba2) {
                return Hba2.class.getSimpleName();
            }
            if (cardType instanceof Smcb2) {
                return Smcb2.class.getSimpleName();
            }
            if (cardType instanceof Smcb21) {
                return Smcb21.class.getSimpleName();
            }
        }
        throw new HealthcardControlRuntimeException("card is invalid");
    }

    private static /* synthetic */ ResultOperation lambda$readActorNameFromAutCert$0(AbstractHealthCardCommand readESignCommand, IHealthCard cardHc, Response __) throws Throwable {
        return readESignCommand.executeOn(cardHc);
    }
}

