/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.protocol;

import de.gematik.ti.healthcard.control.entities.card.ProtocolEntry;
import de.gematik.ti.healthcard.control.exceptions.HealthcardControlRuntimeException;
import de.gematik.ti.healthcardaccess.IHealthCard;
import de.gematik.ti.healthcardaccess.cardobjects.ApplicationIdentifier;
import de.gematik.ti.healthcardaccess.cardobjects.FileIdentifier;
import de.gematik.ti.healthcardaccess.cardobjects.Format2Pin;
import de.gematik.ti.healthcardaccess.cardobjects.Password;
import de.gematik.ti.healthcardaccess.cardobjects.ShortFileIdentifier;
import de.gematik.ti.healthcardaccess.commands.ReadRecordCommand;
import de.gematik.ti.healthcardaccess.commands.SelectCommand;
import de.gematik.ti.healthcardaccess.commands.VerifyCommand;
import de.gematik.ti.healthcardaccess.healthcards.Egk2;
import de.gematik.ti.healthcardaccess.healthcards.Egk21;
import de.gematik.ti.healthcardaccess.healthcards.HealthCardStatusValid;
import de.gematik.ti.healthcardaccess.operation.ResultOperation;
import de.gematik.ti.healthcardaccess.result.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolReader
implements Callable {
    private static final int MAXIMUMNUMBEROFRECORDS = 50;
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolReader.class);
    private final IHealthCard cardEgk;
    private final ResultOperation<byte[]> responseResultOperation;
    private final Collection<ProtocolEntry> allProtocolEntries = new ArrayList<ProtocolEntry>();
    private static Password mrPinHomePWID;
    private static ApplicationIdentifier dfHcaAID;
    private static FileIdentifier efLoggingFID;
    private static ShortFileIdentifier efLoggingSFID;

    public ProtocolReader(IHealthCard cardEgk, Format2Pin pin) {
        this.cardEgk = cardEgk;
        ProtocolReader.initFileReference(cardEgk);
        this.responseResultOperation = new VerifyCommand(mrPinHomePWID, false, pin).executeOn(cardEgk).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).flatMap(__ -> new SelectCommand(dfHcaAID).executeOn(cardEgk).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0))).flatMap(__ -> new SelectCommand(efLoggingFID, false).executeOn(cardEgk).map(Response::getResponseData));
    }

    private static void initFileReference(IHealthCard cardHc) {
        if (cardHc.getStatus().isValid() && ((HealthCardStatusValid)cardHc.getStatus()).getHealthCardType() instanceof Egk2) {
            mrPinHomePWID = new Password(2);
            dfHcaAID = new ApplicationIdentifier("D27600000102");
            efLoggingFID = new FileIdentifier(53254);
            efLoggingSFID = new ShortFileIdentifier(6);
        } else if (cardHc.getStatus().isValid() && ((HealthCardStatusValid)cardHc.getStatus()).getHealthCardType() instanceof Egk21) {
            mrPinHomePWID = new Password(2);
            dfHcaAID = new ApplicationIdentifier("D27600000102");
            efLoggingFID = new FileIdentifier(53254);
            efLoggingSFID = new ShortFileIdentifier(6);
        } else {
            throw new HealthcardControlRuntimeException("Cardtype " + ((HealthCardStatusValid)cardHc.getStatus()).getHealthCardType() + " is invalid or unknown");
        }
    }

    public Collection<ProtocolEntry> call() {
        return this.allProtocolEntries;
    }

    public ResultOperation<Boolean> read() {
        ResultOperation<Boolean> resultOperation = this.doFirstRead(1, this.allProtocolEntries);
        for (int recordNumber = 2; recordNumber < 51; ++recordNumber) {
            resultOperation = this.doRead(resultOperation, recordNumber, this.allProtocolEntries);
        }
        return resultOperation;
    }

    private ResultOperation<Boolean> doFirstRead(int recordNumber, Collection list) {
        ResultOperation resultOperation = this.responseResultOperation.flatMap(__ -> new ReadRecordCommand(efLoggingSFID, recordNumber).executeOn(this.cardEgk)).map(Response::getResponseData).map(ProtocolEntry::new).map(e -> list.add(e));
        return resultOperation;
    }

    private ResultOperation<Boolean> doRead(ResultOperation<Boolean> resultOperation, int recordNumber, Collection list) {
        resultOperation = resultOperation.flatMap(__ -> new ReadRecordCommand(efLoggingSFID, recordNumber).executeOn(this.cardEgk)).map(Response::getResponseData).map(ProtocolEntry::new).map(e -> list.add(e));
        return resultOperation;
    }

    public Collection<ProtocolEntry> getAllProtocolEntries() {
        return this.allProtocolEntries;
    }
}

