/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.protocol;

import de.gematik.ti.healthcard.control.entities.card.ProtocolEntry;
import de.gematik.ti.healthcard.control.exceptions.HealthcardControlRuntimeException;
import de.gematik.ti.healthcard.control.protocol.ProtocolReader;
import de.gematik.ti.healthcard.control.protocol.ProtocolWriter;
import de.gematik.ti.healthcardaccess.IHealthCard;
import de.gematik.ti.healthcardaccess.cardobjects.Format2Pin;
import de.gematik.ti.healthcardaccess.operation.ResultOperation;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EgkCardProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(EgkCardProtocol.class);
    private final IHealthCard cardEgkHc;
    private final Format2Pin pin;
    private ProtocolReader protocolReader = null;

    public EgkCardProtocol(IHealthCard cardEgkHc, Format2Pin pin) {
        this.cardEgkHc = cardEgkHc;
        this.pin = pin;
    }

    public ResultOperation write(ProtocolEntry protocolEntry) {
        ProtocolWriter protocolWriter = new ProtocolWriter(this.cardEgkHc);
        return protocolWriter.write(protocolEntry);
    }

    public ResultOperation<Boolean> read() {
        this.protocolReader = new ProtocolReader(this.cardEgkHc, this.pin);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        LOG.debug("executor submits the protocolReader: " + this.protocolReader);
        executor.submit(this.protocolReader);
        executor.shutdown();
        return this.protocolReader.read();
    }

    public Collection<ProtocolEntry> getAllProtocolEntries() {
        if (this.protocolReader == null) {
            throw new HealthcardControlRuntimeException("call 'read()' firstly");
        }
        LOG.debug("protocolReader run call()");
        return this.protocolReader.call();
    }

    public Stream<ProtocolEntry> getValidProtocolEntries() {
        return this.getAllProtocolEntries().stream().filter(ProtocolEntry::isValidProtocolEntry);
    }
}

