/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.nfdm.states;

import de.gematik.ti.healthcard.control.exceptions.NfdDpeExtractException;
import de.gematik.ti.healthcardaccess.operation.Result;
import de.gematik.ti.healthcardaccess.result.Response;
import de.gematik.ti.utils.codec.Hex;

public enum NfdDpeVersionState {
    NFD_DPE_VERSION_PERMITTED,
    NFD_DPE_VERSION_INADMISSIBLE;

    private static final int POSITION = 20;
    private static final String PERMITTED_VERSION = "0010000000";

    public static NfdDpeVersionState getVersionState(Response response) {
        byte[] responseData = response.getResponseData();
        byte[] versionData = new byte[responseData.length - 20];
        System.arraycopy(responseData, 20, versionData, 0, responseData.length - 20);
        String version = Hex.encodeHexString((byte[])versionData);
        if (PERMITTED_VERSION.equals(version)) {
            return NFD_DPE_VERSION_PERMITTED;
        }
        return NFD_DPE_VERSION_INADMISSIBLE;
    }

    public Result<NfdDpeVersionState> validateVersion(NfdDpeVersionState state) {
        if (this == NFD_DPE_VERSION_PERMITTED) {
            return Result.success((Object)((Object)state));
        }
        return Result.failure((Throwable)new NfdDpeExtractException(String.format("expected state: %s, but was: %s", new Object[]{this, state})));
    }
}

