/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.nfdm.states;

import de.gematik.ti.healthcard.control.exceptions.NfdDpeExtractException;
import de.gematik.ti.healthcardaccess.operation.Result;
import de.gematik.ti.healthcardaccess.result.Response;

public enum NfdDpeState {
    TRANSACTIONS_OPEN,
    NO_TRANSACTIONS_OPEN;


    public static NfdDpeState getState(Response response) {
        byte[] responseData = response.getResponseData();
        byte[] stateBytes = new byte[1];
        System.arraycopy(responseData, 0, stateBytes, 0, 1);
        char nfdState = (char)stateBytes[0];
        if (nfdState == '0') {
            return NO_TRANSACTIONS_OPEN;
        }
        return TRANSACTIONS_OPEN;
    }

    public Result<NfdDpeState> validateState(NfdDpeState state) {
        if (this == state) {
            return Result.success((Object)((Object)state));
        }
        return Result.failure((Throwable)new NfdDpeExtractException(String.format("State: expected state: %s, but was: %s", new Object[]{this, state})));
    }
}

