/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.nfdm.states;

import de.gematik.ti.healthcard.control.exceptions.NfdDpeExtractException;
import de.gematik.ti.healthcardaccess.WrongCardDataException;
import de.gematik.ti.healthcardaccess.cardobjects.FileControlParameter;
import de.gematik.ti.healthcardaccess.operation.Result;
import de.gematik.ti.healthcardaccess.result.Response;

public enum NfdDpeLifeCycleState {
    LCS_CREATION_STATE,
    LCS_INITIALISATION_STATE,
    LCS_OPERATIONAL_STATE_ACTIVATED,
    LCS_OPERATIONAL_STATE_DEACTIVATED,
    LCS_TERMINATION_STATE;


    public static NfdDpeLifeCycleState getLifeCycleStateResult(Response response) throws WrongCardDataException {
        byte[] responseData = response.getResponseData();
        if (responseData.length == 0) {
            return LCS_OPERATIONAL_STATE_DEACTIVATED;
        }
        FileControlParameter fcp = new FileControlParameter(response.getResponseData());
        FileControlParameter.LifeCycleStates lifeCycleStatus = fcp.getLifeCycleStatus();
        switch (lifeCycleStatus) {
            case LCS_OPERATIONAL_STATE_ACTIVATED: {
                return LCS_OPERATIONAL_STATE_ACTIVATED;
            }
            case LCS_CREATION_STATE: {
                return LCS_CREATION_STATE;
            }
            case LCS_TERMINATION_STATE: {
                return LCS_TERMINATION_STATE;
            }
            case LCS_INITIALISATION_STATE: {
                return LCS_INITIALISATION_STATE;
            }
            case LCS_OPERATIONAL_STATE_DEACTIVATED: {
                return LCS_OPERATIONAL_STATE_DEACTIVATED;
            }
        }
        return LCS_OPERATIONAL_STATE_DEACTIVATED;
    }

    public Result<NfdDpeLifeCycleState> validateLifeCycleState(NfdDpeLifeCycleState state) {
        if (!state.equals((Object)LCS_OPERATIONAL_STATE_DEACTIVATED)) {
            return Result.success((Object)((Object)state));
        }
        return Result.failure((Throwable)new NfdDpeExtractException(String.format("NfdLifeCycleState: expected state: %s, but was: %s", new Object[]{this, state})));
    }
}

