/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.nfdm.states;

import de.gematik.ti.healthcard.control.exceptions.NfdDpeExtractException;
import de.gematik.ti.healthcardaccess.operation.Result;
import de.gematik.ti.healthcardaccess.result.Response;
import de.gematik.ti.utils.codec.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum NfdDpeDataAvailableState {
    DATA_AVAILABLE,
    NO_DATA_AVAILABLE;

    private static final Logger LOG;
    private static final String TAG = "NfdDpeDataAvailableState: ";

    public static NfdDpeDataAvailableState getDataAvailableState(Response response) {
        byte[] responseData = response.getResponseData();
        byte[] le = new byte[2];
        String leString = "";
        if (responseData.length >= 2) {
            System.arraycopy(responseData, 0, le, 0, 2);
            leString = Hex.encodeHexString((byte[])le);
            LOG.debug(TAG, (Object)("DataLength: " + leString));
        }
        if ("0000".equals(leString) || leString.length() < 2) {
            return NO_DATA_AVAILABLE;
        }
        return DATA_AVAILABLE;
    }

    public Result<NfdDpeDataAvailableState> validateDataAvailableState(NfdDpeDataAvailableState state) {
        if (this == state) {
            return Result.success((Object)((Object)state));
        }
        return Result.failure((Throwable)new NfdDpeExtractException(String.format("expected state: %s, but was: %s", new Object[]{this, state})));
    }

    static {
        LOG = LoggerFactory.getLogger(NfdDpeDataAvailableState.class);
    }
}

