/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.nfdm.states;

import de.gematik.ti.healthcard.control.nfdm.states.AccessRule;
import de.gematik.ti.healthcard.control.role.ProfessionalRole;
import java.util.HashMap;
import java.util.Map;

public enum AccessRight {
    ACCESS_MRPIN_NFD,
    ACCESS_MRPIN_NFD_READ,
    ACCESS_MRPIN_DPE,
    ACCESS_MRPIN_DPE_READ,
    ACCESS_NO_PIN,
    EMERGENCY_ACCESS_NO_PIN,
    NO_ACCESS;

    private static final int RULE_1 = 1;
    private static final int RULE_2 = 2;
    private static final int RULE_3 = 3;
    private static final Map<ProfessionalRole, Integer> ROLE_INTEGER_MAP_NFD;
    private static final Map<ProfessionalRole, Integer> ROLE_INTEGER_MAP_DPE_EGK2;
    private static final Map<ProfessionalRole, Integer> ROLE_INTEGER_MAP_DPE_EGK21;

    private static AccessRight getRule1AccessRight(AccessRule accessRule, AccessRight accessRightDefault) {
        AccessRight right = accessRightDefault;
        if (AccessRule.R1.equals((Object)accessRule)) {
            right = EMERGENCY_ACCESS_NO_PIN;
        } else if (AccessRule.R2.equals((Object)accessRule) || AccessRule.R4.equals((Object)accessRule)) {
            right = ACCESS_NO_PIN;
        }
        return right;
    }

    public static AccessRight getAccessRightNfd(ProfessionalRole professionalRole, AccessRule accessRule) {
        AccessRight right = NO_ACCESS;
        if (ROLE_INTEGER_MAP_NFD.containsKey((Object)professionalRole)) {
            int ruleInt = ROLE_INTEGER_MAP_NFD.get((Object)professionalRole);
            switch (ruleInt) {
                case 1: {
                    right = AccessRight.getRule1AccessRight(accessRule, ACCESS_MRPIN_NFD);
                    break;
                }
                case 2: {
                    if (!AccessRule.R3.equals((Object)accessRule) && !AccessRule.R4.equals((Object)accessRule)) break;
                    right = ACCESS_MRPIN_NFD_READ;
                    break;
                }
                case 3: {
                    if (AccessRule.R1.equals((Object)accessRule)) {
                        right = EMERGENCY_ACCESS_NO_PIN;
                        break;
                    }
                    if (!AccessRule.R3.equals((Object)accessRule) && !AccessRule.R4.equals((Object)accessRule)) break;
                    right = ACCESS_MRPIN_NFD_READ;
                    break;
                }
            }
        }
        return right;
    }

    public static AccessRight getAccessRightDpeEgk2(ProfessionalRole professionalRole, AccessRule accessRule) {
        AccessRight right = NO_ACCESS;
        if (ROLE_INTEGER_MAP_DPE_EGK2.containsKey((Object)professionalRole)) {
            int ruleInt = ROLE_INTEGER_MAP_DPE_EGK2.get((Object)professionalRole);
            switch (ruleInt) {
                case 1: {
                    right = AccessRight.getRule1AccessRight(accessRule, ACCESS_MRPIN_DPE);
                    break;
                }
                case 2: {
                    if (!AccessRule.R3.equals((Object)accessRule) && !AccessRule.R4.equals((Object)accessRule)) break;
                    right = ACCESS_MRPIN_DPE_READ;
                    break;
                }
                case 3: {
                    if (AccessRule.R1.equals((Object)accessRule)) {
                        right = EMERGENCY_ACCESS_NO_PIN;
                        break;
                    }
                    if (!AccessRule.R3.equals((Object)accessRule) && !AccessRule.R4.equals((Object)accessRule)) break;
                    right = ACCESS_MRPIN_DPE_READ;
                    break;
                }
            }
        }
        return right;
    }

    public static AccessRight getAccessRightDpeEgk21(ProfessionalRole professionalRole, AccessRule accessRule) {
        int ruleInt;
        AccessRight right = NO_ACCESS;
        if (ROLE_INTEGER_MAP_DPE_EGK21.containsKey((Object)professionalRole) && (ruleInt = ROLE_INTEGER_MAP_DPE_EGK21.get((Object)professionalRole).intValue()) == 1) {
            right = AccessRight.getRule1AccessRight(accessRule, ACCESS_MRPIN_DPE);
        }
        return right;
    }

    static {
        ROLE_INTEGER_MAP_NFD = new HashMap<ProfessionalRole, Integer>(){
            {
                this.put(ProfessionalRole.ARZT, 1);
                this.put(ProfessionalRole.PRAXIS_ARZT, 1);
                this.put(ProfessionalRole.KRANKENHAUS, 1);
                this.put(ProfessionalRole.ZAHNARZT, 1);
                this.put(ProfessionalRole.PRAXIS_ZAHNARZT, 1);
                this.put(ProfessionalRole.APOTHEKER, 2);
                this.put(ProfessionalRole.MITARBEITER_APOTHEKE, 2);
                this.put(ProfessionalRole.PS_PSYCHOTHERAPEUT, 2);
                this.put(ProfessionalRole.PRAXIS_PSYCHOTHERAPEUT, 2);
                this.put(ProfessionalRole.OEFFENTLICHE_APOTHEKE, 2);
                this.put(ProfessionalRole.BUNDESWEHR_APOTHEKE, 2);
                this.put(ProfessionalRole.KRANKENHAUS_APOTHEKE, 2);
                this.put(ProfessionalRole.ANDERER_HEILBERUF, 3);
            }
        };
        ROLE_INTEGER_MAP_DPE_EGK2 = new HashMap<ProfessionalRole, Integer>(){
            {
                this.put(ProfessionalRole.ARZT, 1);
                this.put(ProfessionalRole.PRAXIS_ARZT, 1);
                this.put(ProfessionalRole.KRANKENHAUS, 1);
                this.put(ProfessionalRole.VERSICHERTER, 2);
            }
        };
        ROLE_INTEGER_MAP_DPE_EGK21 = new HashMap<ProfessionalRole, Integer>(){
            {
                this.put(ProfessionalRole.ARZT, 1);
                this.put(ProfessionalRole.PRAXIS_ARZT, 1);
                this.put(ProfessionalRole.KRANKENHAUS, 1);
            }
        };
    }
}

