/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.nfdm;

import de.gematik.ti.healthcard.control.CardUnlocker;
import de.gematik.ti.healthcard.control.CardVerifier;
import de.gematik.ti.healthcard.control.c2c.C2CSuccessState;
import de.gematik.ti.healthcard.control.c2c.CardToCardAuthExecutor;
import de.gematik.ti.healthcard.control.entities.PinResult;
import de.gematik.ti.healthcard.control.entities.PinType;
import de.gematik.ti.healthcard.control.entities.card.ProtocolEntry;
import de.gematik.ti.healthcard.control.entities.card.certificate.AuthenticationCertificateState;
import de.gematik.ti.healthcard.control.entities.card.pin.PinState;
import de.gematik.ti.healthcard.control.exceptions.HealthcardControlRuntimeException;
import de.gematik.ti.healthcard.control.exceptions.NfdDpeExtractException;
import de.gematik.ti.healthcard.control.nfdm.AccessRightWrapper;
import de.gematik.ti.healthcard.control.nfdm.NfdDpeReader;
import de.gematik.ti.healthcard.control.nfdm.states.AccessRight;
import de.gematik.ti.healthcard.control.nfdm.states.AccessRule;
import de.gematik.ti.healthcard.control.nfdm.states.DataType;
import de.gematik.ti.healthcard.control.nfdm.states.NfdDpeDataAvailableState;
import de.gematik.ti.healthcard.control.nfdm.states.NfdDpeLifeCycleState;
import de.gematik.ti.healthcard.control.nfdm.states.NfdDpeState;
import de.gematik.ti.healthcard.control.nfdm.states.NfdDpeVersionState;
import de.gematik.ti.healthcard.control.protocol.ProtocolRecordBuilder;
import de.gematik.ti.healthcard.control.protocol.ProtocolWriter;
import de.gematik.ti.healthcard.control.role.ProfessionalRole;
import de.gematik.ti.healthcardaccess.IHealthCard;
import de.gematik.ti.healthcardaccess.IHealthCardStatus;
import de.gematik.ti.healthcardaccess.IHealthCardType;
import de.gematik.ti.healthcardaccess.cardobjects.ApplicationIdentifier;
import de.gematik.ti.healthcardaccess.cardobjects.FileIdentifier;
import de.gematik.ti.healthcardaccess.cardobjects.Password;
import de.gematik.ti.healthcardaccess.cardobjects.ShortFileIdentifier;
import de.gematik.ti.healthcardaccess.healthcards.Egk2;
import de.gematik.ti.healthcardaccess.healthcards.Egk21;
import de.gematik.ti.healthcardaccess.healthcards.HealthCardStatusValid;
import de.gematik.ti.healthcardaccess.operation.Result;
import de.gematik.ti.healthcardaccess.operation.ResultOperation;
import de.gematik.ti.healthcardaccess.operation.Subscriber;
import de.gematik.ti.healthcardaccess.result.Response;
import de.gematik.ti.schema.gen.dpe.v1_0.DPE_DPE_Document;
import de.gematik.ti.schema.gen.nfd.v1_3.NFD_NFD_Document;
import de.gematik.ti.utils.codec.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NfdDpeService {
    private static final Logger LOG = LoggerFactory.getLogger(NfdDpeService.class);
    private static final String NFD_DATATYPE = "2";
    private final IHealthCard authorisingCard;
    private final IHealthCard cardToRead;
    private final PinState[] pinStateEnum = new PinState[1];
    private final ProfessionalRole[] role = new ProfessionalRole[1];
    private final AccessRule[] accessRules = new AccessRule[1];
    private final AccessRight[] accessRights = new AccessRight[1];
    private NfdDpeReader nfdDpeReader;
    private CardVerifier cardToReadVerifier;
    private Password passwordMrPinDpe;
    private Password passwordMrNfd;
    private ApplicationIdentifier nfdDfAid;
    private ApplicationIdentifier dpeDfAid;
    private ShortFileIdentifier statusNfdSfid;
    private ShortFileIdentifier nfdSfid;
    private ShortFileIdentifier dpeEfSfid;
    private FileIdentifier nfdEfFid;
    private FileIdentifier dpeEfFid;
    private ShortFileIdentifier dpeStatusEfSfid;

    public NfdDpeService(IHealthCard cardToRead, IHealthCard authorisingCard) {
        this.initFileReference(cardToRead);
        this.authorisingCard = authorisingCard;
        this.cardToRead = cardToRead;
        this.nfdDpeReader = new NfdDpeReader(cardToRead);
    }

    private void initFileReference(IHealthCard cardHc) {
        if (cardHc.getStatus().isValid() && ((HealthCardStatusValid)cardHc.getStatus()).getHealthCardType() instanceof Egk2) {
            this.passwordMrPinDpe = new Password(4);
            this.passwordMrNfd = new Password(3);
            this.statusNfdSfid = new ShortFileIdentifier(14);
            this.nfdDfAid = new ApplicationIdentifier("D27600014407");
            this.nfdEfFid = new FileIdentifier(53264);
            this.nfdSfid = new ShortFileIdentifier(16);
            this.dpeStatusEfSfid = new ShortFileIdentifier(24);
            this.dpeEfFid = new FileIdentifier(53275);
            this.dpeDfAid = new ApplicationIdentifier("D27600014408");
            this.dpeEfSfid = new ShortFileIdentifier(27);
        } else if (cardHc.getStatus().isValid() && ((HealthCardStatusValid)cardHc.getStatus()).getHealthCardType() instanceof Egk21) {
            this.passwordMrPinDpe = new Password(4);
            this.passwordMrNfd = new Password(3);
            this.nfdDfAid = new ApplicationIdentifier("D27600014407");
            this.statusNfdSfid = new ShortFileIdentifier(14);
            this.nfdEfFid = new FileIdentifier(53264);
            this.nfdSfid = new ShortFileIdentifier(16);
            this.dpeStatusEfSfid = new ShortFileIdentifier(24);
            this.dpeEfFid = new FileIdentifier(53275);
            this.dpeDfAid = new ApplicationIdentifier("D27600014408");
            this.dpeEfSfid = new ShortFileIdentifier(27);
        } else {
            throw new HealthcardControlRuntimeException("Cardtype " + ((HealthCardStatusValid)cardHc.getStatus()).getHealthCardType() + " is invalid or unknown");
        }
    }

    public NFD_NFD_Document getNfdDocument(boolean emergencyIndicator, boolean updateIndicator) {
        NFD_NFD_Document[] nfdDocument = new NFD_NFD_Document[1];
        ResultOperation<C2CSuccessState> resultOperaitonAuth = this.prepareAuth(emergencyIndicator, updateIndicator, this.passwordMrPinDpe, DataType.NFD);
        ResultOperation resultOperaiton = resultOperaitonAuth.flatMap(__ -> this.prepareGetDocument(this.nfdDfAid, this.nfdSfid, this.statusNfdSfid, this.nfdEfFid));
        resultOperaiton.map(document -> NFD_NFD_Document.deserialize((Node)document.getDocumentElement())).subscribe(new NfdDpeServiceSubscriber<NFD_NFD_Document>(nfdDocument));
        return nfdDocument[0];
    }

    public DPE_DPE_Document getDpeDocument(boolean emergencyIndicator, boolean updateIndicator) {
        DPE_DPE_Document[] dpeDocument = new DPE_DPE_Document[1];
        ResultOperation<C2CSuccessState> resultOperaitonAuth = this.prepareAuth(emergencyIndicator, updateIndicator, this.passwordMrPinDpe, DataType.DPE);
        ResultOperation resultOperaiton = resultOperaitonAuth.flatMap(__ -> this.prepareGetDocument(this.dpeDfAid, this.dpeEfSfid, this.dpeStatusEfSfid, this.dpeEfFid));
        resultOperaiton.map(document -> DPE_DPE_Document.deserialize((Node)document.getDocumentElement())).subscribe(new NfdDpeServiceSubscriber<DPE_DPE_Document>(dpeDocument));
        return dpeDocument[0];
    }

    private ResultOperation<C2CSuccessState> prepareAuth(boolean emergencyIndicator, boolean updateIndicator, Password password, DataType dataType) {
        this.cardToReadVerifier = new CardVerifier(this.cardToRead);
        CardVerifier authorisingCardVerifier = new CardVerifier(this.authorisingCard);
        LOG.debug("emergencyIndicator: {}, updateIndicator: {}", (Object)emergencyIndicator, (Object)updateIndicator);
        CardUnlocker cardUnlocker = new CardUnlocker(this.authorisingCard);
        return this.cardToReadVerifier.checkCard().validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).flatMap(__ -> this.cardToReadVerifier.checkAuthCertificate()).validate(AuthenticationCertificateState.VALIDATION_SUCCESS::getValidationResult).flatMap(__ -> this.cardToReadVerifier.getPinState(password)).map(pinState -> {
            this.pinStateEnum[0] = pinState;
            return this.pinStateEnum[0];
        }).flatMap(__ -> cardUnlocker.getProfessionalRole()).map(professionalRole -> {
            this.role[0] = professionalRole;
            return this.role[0];
        }).map(__ -> AccessRule.getAccessRule(this.pinStateEnum[0], emergencyIndicator, updateIndicator)).map(accessRule -> {
            this.accessRules[0] = accessRule;
            return this.accessRules[0];
        }).map(__ -> new AccessRightWrapper(this.cardToRead, dataType).getAccessRight(this.role[0], this.accessRules[0])).map(accessRight -> {
            this.accessRights[0] = accessRight;
            return this.accessRights[0];
        }).flatMap(__ -> this.checkAccessRights(this.accessRights[0])).flatMap(__ -> authorisingCardVerifier.verifyPin(PinType.PIN_CH)).validate(pr -> this.validatePinResult((PinResult)pr)).flatMap(__ -> CardToCardAuthExecutor.authenticateC2C(this.cardToRead, this.authorisingCard)).validate(C2CSuccessState.C2C_SUCCESS::validateSuccessState);
    }

    private ResultOperation<Document> prepareGetDocument(ApplicationIdentifier aid, ShortFileIdentifier efSfid, ShortFileIdentifier statusEfSfid, FileIdentifier fid) {
        CardUnlocker cardUnlocker = new CardUnlocker(this.authorisingCard);
        this.nfdDpeReader = new NfdDpeReader(this.cardToRead);
        return this.createProtocolRecord().map(this::writeProtocol).flatMap(__ -> this.verifyPinByAccessRight(this.accessRights[0])).validate(pr -> this.validatePinResult((PinResult)pr)).flatMap(__ -> this.createProtocolRecord()).map(this::writeProtocol).flatMap(__ -> this.nfdDpeReader.readLifeCycleState(aid)).validate(NfdDpeLifeCycleState.LCS_OPERATIONAL_STATE_ACTIVATED::validateLifeCycleState).flatMap(__ -> this.nfdDpeReader.checkConsistency(aid, statusEfSfid)).validate(NfdDpeState.NO_TRANSACTIONS_OPEN::validateState).flatMap(__ -> this.nfdDpeReader.checkContainerVersion(aid, statusEfSfid)).validate(NfdDpeVersionState.NFD_DPE_VERSION_PERMITTED::validateVersion).flatMap(__ -> this.nfdDpeReader.checkSize(aid, efSfid)).validate(NfdDpeDataAvailableState.DATA_AVAILABLE::validateDataAvailableState).flatMap(__ -> this.nfdDpeReader.extractDocument(aid, efSfid, fid));
    }

    private Result<PinResult> validatePinResult(PinResult pr) {
        if (pr.isPinVerifiSuccess()) {
            return Result.success((Object)pr);
        }
        return Result.failure((Throwable)new Exception(pr.getErrorTextByFailure()));
    }

    private ResultOperation<byte[]> createProtocolRecord() {
        String typeAccess = "";
        LOG.debug("accessRules[0]: " + (Object)((Object)this.accessRules[0]));
        switch (this.accessRules[0]) {
            case R1: {
                typeAccess = "N";
                break;
            }
            case R2: {
                typeAccess = "A";
            }
        }
        LOG.debug("typeAccess: " + typeAccess);
        LOG.debug("accessRights[0]: " + (Object)((Object)this.accessRights[0]));
        switch (this.accessRights[0]) {
            case ACCESS_MRPIN_NFD: 
            case ACCESS_MRPIN_NFD_READ: 
            case ACCESS_MRPIN_DPE_READ: 
            case ACCESS_MRPIN_DPE: {
                typeAccess = "R";
                break;
            }
            case ACCESS_NO_PIN: {
                typeAccess = "r";
            }
        }
        LOG.debug("typeAccess: " + typeAccess);
        byte[] protocolRecord = ProtocolRecordBuilder.buildRecord(this.authorisingCard, NFD_DATATYPE, typeAccess);
        LOG.debug("ProtocolEntry: " + Hex.encodeHexString((byte[])protocolRecord));
        return ResultOperation.unitRo((Object)protocolRecord);
    }

    private ResultOperation writeProtocol(byte[] protocolRecord) {
        IHealthCardStatus healthCardStatus = this.cardToRead.getStatus();
        IHealthCardType cardType = ((HealthCardStatusValid)healthCardStatus).getHealthCardType();
        ProtocolWriter protocolWriter = new ProtocolWriter(this.cardToRead);
        if (cardType instanceof Egk2) {
            return protocolWriter.write(ProtocolEntry.createProtocolEntry(protocolRecord));
        }
        if (cardType instanceof Egk21) {
            return protocolWriter.write(ProtocolEntry.createProtocolEntry(protocolRecord));
        }
        return ResultOperation.unitRo((Object)Response.ResponseStatus.SUCCESS);
    }

    private ResultOperation<AccessRight> checkAccessRights(AccessRight accessRight) {
        if (accessRight == AccessRight.NO_ACCESS) {
            throw new NfdDpeExtractException("You are not authorized to read the emergency data (NFD) or personal explanations (DPE)");
        }
        return ResultOperation.unitRo((Object)((Object)accessRight));
    }

    private ResultOperation<PinResult> verifyPinByAccessRight(AccessRight accessRight) {
        boolean isPinVerificationRequired = true;
        PinType pinType = null;
        LOG.debug("accessRight:" + (Object)((Object)accessRight));
        switch (accessRight) {
            case ACCESS_MRPIN_NFD: {
                pinType = PinType.MRPIN_NFD;
                break;
            }
            case ACCESS_MRPIN_NFD_READ: {
                pinType = PinType.MRPIN_NFD_READ;
                break;
            }
            case ACCESS_MRPIN_DPE: {
                pinType = PinType.MRPIN_DPE;
                break;
            }
            case ACCESS_MRPIN_DPE_READ: {
                pinType = PinType.MRPIN_DPE_READ;
                break;
            }
            case NO_ACCESS: {
                throw new NfdDpeExtractException("You are not authorized to read the emergency data (NFD) or personal explanations (DPE)");
            }
            default: {
                isPinVerificationRequired = false;
            }
        }
        if (isPinVerificationRequired) {
            return this.cardToReadVerifier.verifyPin(pinType);
        }
        return ResultOperation.unitRo((Object)new PinResult("NO_ERROR").setPinVerifiSuccess(true));
    }

    public class NfdDpeServiceSubscriber<T>
    implements Subscriber {
        private final T[] document;

        public NfdDpeServiceSubscriber(T[] document) {
            this.document = document;
        }

        public void onSuccess(Object value) {
            this.document[0] = value;
            LOG.debug("Success on extract Document");
        }

        public void onError(Throwable t) throws RuntimeException {
            LOG.error("Error on extract Document occured: " + t);
        }
    }
}

