/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.nfdm;

import de.gematik.ti.healthcard.control.exceptions.HealthcardControlRuntimeException;
import de.gematik.ti.healthcard.control.nfdm.states.NfdDpeDataAvailableState;
import de.gematik.ti.healthcard.control.nfdm.states.NfdDpeLifeCycleState;
import de.gematik.ti.healthcard.control.nfdm.states.NfdDpeState;
import de.gematik.ti.healthcard.control.nfdm.states.NfdDpeVersionState;
import de.gematik.ti.healthcardaccess.AbstractHealthCardCommand;
import de.gematik.ti.healthcardaccess.IHealthCard;
import de.gematik.ti.healthcardaccess.cardobjects.ApplicationIdentifier;
import de.gematik.ti.healthcardaccess.cardobjects.FileIdentifier;
import de.gematik.ti.healthcardaccess.cardobjects.ShortFileIdentifier;
import de.gematik.ti.healthcardaccess.commands.ReadCommand;
import de.gematik.ti.healthcardaccess.commands.SelectCommand;
import de.gematik.ti.healthcardaccess.operation.ResultOperation;
import de.gematik.ti.healthcardaccess.operation.Subscriber;
import de.gematik.ti.healthcardaccess.result.Response;
import de.gematik.ti.utils.codec.Hex;
import de.gematik.ti.utils.primitives.Bytes;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class NfdDpeReader {
    private static final Logger LOG = LoggerFactory.getLogger(NfdDpeReader.class);
    private static final String TAG = "NfdDpeReader: ";
    private static final int RADIX = 16;
    private final Subscriber<byte[]> subscriber = this.getSubscriber();
    private IHealthCard cardToRead = null;

    NfdDpeReader(IHealthCard cardToRead) {
        this.cardToRead = cardToRead;
    }

    private static int dataInfoToLength(byte[] dataInfo) {
        String le1 = Hex.encodeHexString((byte[])dataInfo);
        int nfdSize = Integer.parseInt(le1, 16);
        LOG.debug("Size int: " + nfdSize);
        return nfdSize;
    }

    private static ResultOperation<Document> convertStringToXMLDocument(String xmlString) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return ResultOperation.unitRo((Object)builder.parse(new InputSource(new StringReader(xmlString))));
        }
        catch (Exception e) {
            LOG.error(TAG, (Object)("Error on parsing xml " + e.getMessage()));
            return null;
        }
    }

    private static ResultOperation<String> getUncompressed(byte[] compressedDpe) {
        StringBuilder sb;
        Charset charSet = NfdDpeReader.getCharSettingFirst(compressedDpe);
        try (ByteArrayInputStream bis = new ByteArrayInputStream(compressedDpe);
             GZIPInputStream gis = new GZIPInputStream(bis);
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)gis, charSet));){
            String line;
            sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            LOG.error(TAG, (Object)("Error on uncompressing: " + e));
            throw new HealthcardControlRuntimeException("Error on uncompressing Data " + e);
        }
        String uncompressedString = sb.toString();
        LOG.debug("Uncompressed: " + uncompressedString);
        return ResultOperation.unitRo((Object)uncompressedString);
    }

    private static Charset getCharSettingFirst(byte[] compressedData) {
        String xml = "";
        try (ByteArrayInputStream bis = new ByteArrayInputStream(compressedData);
             GZIPInputStream gis = new GZIPInputStream(bis);){
            byte[] bytes = new byte[100];
            gis.read(bytes);
            xml = new String(bytes);
        }
        catch (Exception e) {
            LOG.error(e.toString());
            throw new HealthcardControlRuntimeException("While reading compressedData an error occured " + e);
        }
        String def = "encoding=";
        int defLength = "encoding=".length();
        String[] sa = new String[]{""};
        String[] split = xml.split(" ");
        Arrays.stream(split).filter(s -> s.trim().toLowerCase().startsWith("encoding=")).flatMap(str -> {
            Stream<Character> characterStream = str.substring(defLength).chars().mapToObj(c -> Character.valueOf((char)c));
            Optional<Character> first = characterStream.findFirst();
            if (!first.isPresent()) {
                return Stream.of(new Character[0]);
            }
            Character separator = first.get();
            String temp = str.substring(defLength + 1);
            int nextPosition = temp.indexOf(separator.charValue());
            characterStream = temp.substring(0, nextPosition).chars().mapToObj(c -> Character.valueOf((char)c));
            return characterStream;
        }).forEach(a -> {
            sa[0] = sa[0] + a;
        });
        Charset newCharSet = Charset.forName(sa[0]);
        return newCharSet;
    }

    ResultOperation<NfdDpeLifeCycleState> readLifeCycleState(ApplicationIdentifier dfAid) {
        SelectCommand selectCommand = new SelectCommand(dfAid, false, true, 0);
        return selectCommand.executeOn(this.cardToRead).map(NfdDpeLifeCycleState::getLifeCycleStateResult);
    }

    ResultOperation<NfdDpeState> checkConsistency(ApplicationIdentifier aid, ShortFileIdentifier sfid) {
        SelectCommand selectNfdFolderCommand = new SelectCommand(aid);
        ReadCommand readStatusCommand = new ReadCommand(sfid);
        return selectNfdFolderCommand.executeOn(this.cardToRead).flatMap(arg_0 -> this.lambda$checkConsistency$5((AbstractHealthCardCommand)readStatusCommand, arg_0)).map(NfdDpeState::getState);
    }

    ResultOperation<NfdDpeVersionState> checkContainerVersion(ApplicationIdentifier aid, ShortFileIdentifier statusSfid) {
        SelectCommand selectNfdFolderCommand = new SelectCommand(aid);
        ReadCommand readStatusCommand = new ReadCommand(statusSfid);
        return selectNfdFolderCommand.executeOn(this.cardToRead).flatMap(arg_0 -> this.lambda$checkContainerVersion$6((AbstractHealthCardCommand)readStatusCommand, arg_0)).map(NfdDpeVersionState::getVersionState);
    }

    ResultOperation<NfdDpeDataAvailableState> checkSize(ApplicationIdentifier aid, ShortFileIdentifier sfid) {
        SelectCommand selectNfdCommand = new SelectCommand(aid);
        ReadCommand readCommand = new ReadCommand(sfid, 0, 2);
        return selectNfdCommand.executeOn(this.cardToRead).flatMap(arg_0 -> this.lambda$checkSize$7((AbstractHealthCardCommand)readCommand, arg_0)).map(NfdDpeDataAvailableState::getDataAvailableState);
    }

    private ResultOperation<byte[]> extractEfSize(ApplicationIdentifier aid, ShortFileIdentifier sfid) {
        SelectCommand selectCommand = new SelectCommand(aid);
        byte[][] nfdSize = new byte[1][];
        selectCommand.executeOn(this.cardToRead).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).flatMap(__ -> new ReadCommand(sfid, 0, 2).executeOn(this.cardToRead)).map(Response::getResponseData).map(bytes -> {
            nfdSize[0] = bytes;
            return bytes;
        }).subscribe(this.subscriber);
        LOG.debug("extract-Size hex: " + Hex.encodeHexString((byte[])nfdSize[0]));
        return ResultOperation.unitRo((Object)nfdSize[0]);
    }

    private Subscriber<byte[]> getSubscriber() {
        return new Subscriber<byte[]>(){

            public void onSuccess(byte[] value) {
                LOG.debug("Subscriber: " + Hex.encodeHexString((byte[])value));
            }

            public void onError(Throwable t) throws RuntimeException {
                LOG.debug("Subscriber: " + t.getMessage());
            }
        };
    }

    public ResultOperation<Document> extractDocument(ApplicationIdentifier aid, ShortFileIdentifier sfid, FileIdentifier fid) {
        return this.extractEfSize(aid, sfid).map(NfdDpeReader::dataInfoToLength).flatMap(bytesToRead -> this.getCompressedData((Integer)bytesToRead, fid)).flatMap(NfdDpeReader::getUncompressed).flatMap(NfdDpeReader::convertStringToXMLDocument);
    }

    private ResultOperation<byte[]> getCompressedData(Integer bytesToRead, FileIdentifier fid) {
        SelectCommand selectCommand = new SelectCommand(fid, false);
        byte[][] compressedData = new byte[][]{new byte[0]};
        int offset = 2;
        while (bytesToRead > 0) {
            int readBytesLength;
            ReadCommand readDpeCommand;
            if (bytesToRead > this.cardToRead.getCurrentCardChannel().getMaxMessageLength()) {
                readDpeCommand = new ReadCommand(offset, this.cardToRead.getCurrentCardChannel().getMaxMessageLength());
                readBytesLength = this.cardToRead.getCurrentCardChannel().getMaxMessageLength();
            } else {
                readDpeCommand = new ReadCommand(offset, bytesToRead.intValue());
                readBytesLength = bytesToRead;
            }
            ReadCommand finalReadDpeCommand = readDpeCommand;
            selectCommand.executeOn(this.cardToRead).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).flatMap(arg_0 -> this.lambda$getCompressedData$12((AbstractHealthCardCommand)finalReadDpeCommand, compressedData, arg_0)).subscribe(this.subscriber);
            LOG.debug("Compressed: " + Hex.encodeHexString((byte[])compressedData[0]));
            offset += readBytesLength;
            bytesToRead = bytesToRead - readBytesLength;
        }
        return ResultOperation.unitRo((Object)compressedData[0]);
    }

    private /* synthetic */ ResultOperation lambda$getCompressedData$12(AbstractHealthCardCommand finalReadDpeCommand, byte[][] compressedData, Response __) throws Throwable {
        return finalReadDpeCommand.executeOn(this.cardToRead).map(Response::getResponseData).map(bytes -> {
            LOG.debug("extracted Bytes: " + Hex.encodeHexString((byte[])bytes));
            compressedData[0] = Bytes.concatNullables((byte[][])new byte[][]{compressedData[0], bytes});
            return bytes;
        });
    }

    private /* synthetic */ ResultOperation lambda$checkSize$7(AbstractHealthCardCommand readCommand, Response __) throws Throwable {
        return readCommand.executeOn(this.cardToRead);
    }

    private /* synthetic */ ResultOperation lambda$checkContainerVersion$6(AbstractHealthCardCommand readStatusCommand, Response __) throws Throwable {
        return readStatusCommand.executeOn(this.cardToRead);
    }

    private /* synthetic */ ResultOperation lambda$checkConsistency$5(AbstractHealthCardCommand readStatusCommand, Response __) throws Throwable {
        return readStatusCommand.executeOn(this.cardToRead);
    }
}

