/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.nfdm;

import de.gematik.ti.healthcard.control.exceptions.HealthcardControlRuntimeException;
import de.gematik.ti.healthcard.control.nfdm.states.AccessRight;
import de.gematik.ti.healthcard.control.nfdm.states.AccessRule;
import de.gematik.ti.healthcard.control.nfdm.states.DataType;
import de.gematik.ti.healthcard.control.role.ProfessionalRole;
import de.gematik.ti.healthcardaccess.IHealthCard;
import de.gematik.ti.healthcardaccess.IHealthCardType;
import de.gematik.ti.healthcardaccess.healthcards.Egk2;
import de.gematik.ti.healthcardaccess.healthcards.Egk21;
import de.gematik.ti.healthcardaccess.healthcards.HealthCardStatusValid;

public class AccessRightWrapper {
    private final IHealthCard healthCard;
    private final DataType dataType;

    public AccessRightWrapper(IHealthCard cardToRead, DataType dataType) {
        this.healthCard = cardToRead;
        this.dataType = dataType;
    }

    public AccessRight getAccessRight(ProfessionalRole professionalRole, AccessRule accessRule) {
        IHealthCardType healthCardType = ((HealthCardStatusValid)this.healthCard.getStatus()).getHealthCardType();
        if (this.dataType == DataType.NFD) {
            return AccessRight.getAccessRightNfd(professionalRole, accessRule);
        }
        if (this.dataType == DataType.DPE) {
            if (healthCardType instanceof Egk2) {
                return AccessRight.getAccessRightDpeEgk2(professionalRole, accessRule);
            }
            if (healthCardType instanceof Egk21) {
                return AccessRight.getAccessRightDpeEgk21(professionalRole, accessRule);
            }
            throw new HealthcardControlRuntimeException("Cardtype " + healthCardType + " is in this case invalid.");
        }
        throw new HealthcardControlRuntimeException("DataType " + (Object)((Object)this.dataType) + " is in this case invalid.");
    }
}

