/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.entities.card.pin;

import de.gematik.ti.healthcard.control.exceptions.PinStateException;
import de.gematik.ti.healthcardaccess.operation.Result;
import de.gematik.ti.healthcardaccess.result.Response;

public enum PinState {
    TRANSPORT_STATUS_TRANSPORT_PIN,
    TRANSPORT_STATUS_EMPTY_PIN,
    PASSWORD_DISABLED,
    RETRY_COUNTER_COUNT_00,
    RETRY_COUNTER_COUNT_01,
    RETRY_COUNTER_COUNT_02,
    RETRY_COUNTER_COUNT_03,
    NO_ERROR,
    SECURITY_STATUS_NOT_SATISFIED,
    PASSWORD_NOT_FOUND;


    public static PinState getPinStateResult(Response response) {
        switch (response.getResponseStatus()) {
            case TRANSPORT_STATUS_TRANSPORT_PIN: {
                return TRANSPORT_STATUS_TRANSPORT_PIN;
            }
            case TRANSPORT_STATUS_EMPTY_PIN: {
                return TRANSPORT_STATUS_EMPTY_PIN;
            }
            case PASSWORD_DISABLED: {
                return PASSWORD_DISABLED;
            }
            case RETRY_COUNTER_COUNT_01: {
                return RETRY_COUNTER_COUNT_01;
            }
            case RETRY_COUNTER_COUNT_02: {
                return RETRY_COUNTER_COUNT_02;
            }
            case RETRY_COUNTER_COUNT_03: {
                return RETRY_COUNTER_COUNT_03;
            }
            case SUCCESS: {
                return NO_ERROR;
            }
            case SECURITY_STATUS_NOT_SATISFIED: {
                return SECURITY_STATUS_NOT_SATISFIED;
            }
            case PASSWORD_NOT_FOUND: {
                return PASSWORD_NOT_FOUND;
            }
        }
        return RETRY_COUNTER_COUNT_00;
    }

    public Result<PinState> validatePinState(PinState state) {
        if (this == state) {
            return Result.success((Object)((Object)state));
        }
        return Result.failure((Throwable)new PinStateException(String.format("expected status: %s, but was: %s", new Object[]{this, state})));
    }
}

