/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.entities.card.certificate;

import de.gematik.ti.healthcard.control.exceptions.AuthenticationCertificateException;
import de.gematik.ti.healthcardaccess.operation.Result;
import de.gematik.ti.healthcardaccess.result.Response;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

public enum AuthenticationCertificateState {
    VALIDATION_SUCCESS,
    VALIDATION_ERROR;


    public static AuthenticationCertificateState getCertificateValidationResult(Response response) {
        byte[] autCertBytes = response.getResponseData();
        try {
            X509Certificate cert = X509Certificate.getInstance(autCertBytes);
            cert.checkValidity();
            return VALIDATION_SUCCESS;
        }
        catch (CertificateException e) {
            return VALIDATION_ERROR;
        }
    }

    public Result<AuthenticationCertificateState> getValidationResult(AuthenticationCertificateState state) {
        if (this == VALIDATION_SUCCESS) {
            return Result.success((Object)((Object)state));
        }
        return Result.failure((Throwable)new AuthenticationCertificateException(String.format("expected status: %s, but was: %s", new Object[]{this, state})));
    }
}

