/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.entities.card;

import de.gematik.ti.utils.codec.Hex;
import de.gematik.ti.utils.primitives.Bytes;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolEntry {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolEntry.class);
    private static final int MAXIMUMRECORDLENGTH = 46;
    private byte[] record;
    private long timeStamp = 0L;
    private String dataType = "0";
    private String typeAccess = "0";
    private String actorId = "0";
    private String actorName = "0";
    private boolean validProtocolEntry = true;

    public ProtocolEntry(String hexValue) {
        this(Hex.decode((String)hexValue));
    }

    public ProtocolEntry(byte[] record) {
        this.checkRecordValidity(record);
        if (this.validProtocolEntry) {
            this.record = record;
            this.timeStamp = ProtocolEntry.getLongValue(Hex.encodeHexString((byte[])Bytes.copyByteArray((byte[])record, (int)0, (int)4)));
            this.dataType = new String(Bytes.copyByteArray((byte[])record, (int)4, (int)1), CHARSET).trim();
            this.typeAccess = new String(Bytes.copyByteArray((byte[])record, (int)5, (int)1), CHARSET).trim();
            this.actorId = Hex.encodeHexString((byte[])Bytes.copyByteArray((byte[])record, (int)6, (int)10)).replace(" ", "");
            this.actorName = new String(Bytes.copyByteArray((byte[])record, (int)16, (int)30), CHARSET).trim();
        }
    }

    private static boolean isEmpty(byte[] bytes) {
        for (byte bt : bytes) {
            if (bt == 0) continue;
            return false;
        }
        return true;
    }

    public static ProtocolEntry createProtocolEntry(byte[] record) {
        ProtocolEntry protocolEntry = new ProtocolEntry(record);
        return protocolEntry;
    }

    public void checkRecordValidity(byte[] record) {
        if (ProtocolEntry.isEmpty(record)) {
            LOG.warn("no protocol data");
            this.validProtocolEntry = false;
        }
        if (record.length != 46) {
            LOG.error("record is invalid because wrong length " + record.length + ". Its length must be " + 46);
            this.validProtocolEntry = false;
        }
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getTypeAccess() {
        return this.typeAccess;
    }

    public String getActorId() {
        return this.actorId;
    }

    public String getActorName() {
        return this.actorName;
    }

    public byte[] getRecord() {
        return this.record;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProtocolEntry) {
            ProtocolEntry pe = (ProtocolEntry)obj;
            boolean equalsDataType = this.getDataType().equals(pe.getDataType());
            boolean equalsTypeAccess = this.getTypeAccess().equals(pe.getTypeAccess());
            boolean equalsActorName = this.getActorName().equals(pe.getActorName());
            boolean equalsActorId = this.getActorId().equals(pe.getActorId());
            return equalsDataType && equalsTypeAccess && equalsActorName && equalsActorId && this.getTimeStamp() == pe.getTimeStamp();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return super.toString() + "@validProtocolEntry: " + this.validProtocolEntry + "; timeStamp: " + this.getTimeStamp() + "; actorId: " + this.getActorId() + "; actorName: " + this.getActorName() + "; typeAccess: " + this.getTypeAccess() + "; dataType: " + this.getDataType();
    }

    public boolean isValidProtocolEntry() {
        LOG.debug(this + " isValidProtocolEntry: " + this.validProtocolEntry);
        return this.validProtocolEntry;
    }

    public static long getLongValue(String hexValue) {
        return Long.valueOf(hexValue, 16);
    }
}

