/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.entities;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinResult {
    private static final Logger LOG = LoggerFactory.getLogger(PinResult.class);
    private boolean pinVerifiSuccess;
    private int numberRemain = -1;
    private String errorTextByFailure = null;
    private String warningText = null;

    public PinResult(String status) {
        LOG.debug("status: " + status);
        switch (status) {
            case "NO_ERROR": {
                break;
            }
            case "RETRY_COUNTER_COUNT_00": {
                this.setNumberRemain(0);
                this.warningText = "No retry remains";
                break;
            }
            case "RETRY_COUNTER_COUNT_01": {
                this.setNumberRemain(1);
                this.warningText = "1 retry remains";
                break;
            }
            case "RETRY_COUNTER_COUNT_02": {
                this.setNumberRemain(2);
                this.warningText = "2 retries remain";
                break;
            }
            case "RETRY_COUNTER_COUNT_03": {
                this.setNumberRemain(3);
                this.warningText = "3 retries remain";
                break;
            }
            case "TRANSPORT_STATUS_TRANSPORT_PIN": {
                this.errorTextByFailure = "It's a transport-Pin. Please initialize your Pin at first.";
                break;
            }
            case "TRANSPORT_STATUS_EMPTY_PIN": {
                this.errorTextByFailure = "It's a LeerPin. Please initialize your Pin at first.";
                break;
            }
            case "PASSWORD_DISABLED": {
                this.errorTextByFailure = "PASSWORD_DISABLED";
                break;
            }
            case "SECURITY_STATUS_NOT_SATISFIED": {
                this.errorTextByFailure = "SECURITY_STATUS_NOT_SATISFIED";
                break;
            }
            case "PASSWORD_NOT_FOUND": {
                this.errorTextByFailure = "PASSWORD_NOT_FOUND";
                break;
            }
            default: {
                LOG.error("status +" + status + "' is not defined in PinResult.");
            }
        }
    }

    public int getNumberRemain() {
        return this.numberRemain;
    }

    public void setNumberRemain(int numberRemain) {
        this.numberRemain = numberRemain;
    }

    public boolean isPinVerifiSuccess() {
        return this.pinVerifiSuccess;
    }

    public PinResult setPinVerifiSuccess(boolean pinVerifiSuccess) {
        this.pinVerifiSuccess = pinVerifiSuccess;
        return this;
    }

    public String getErrorTextByFailure() {
        return this.errorTextByFailure;
    }

    public String getWarningText() {
        return this.warningText;
    }
}

