/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.c2c;

import de.gematik.ti.healthcard.control.c2c.C2CSuccessState;
import de.gematik.ti.healthcard.control.c2c.CardFileSystemData;
import de.gematik.ti.healthcard.control.exceptions.CardToCardProcessException;
import de.gematik.ti.healthcardaccess.IHealthCard;
import de.gematik.ti.healthcardaccess.IHealthCardType;
import de.gematik.ti.healthcardaccess.cardobjects.Format2Pin;
import de.gematik.ti.healthcardaccess.cardobjects.GemCvCertificate;
import de.gematik.ti.healthcardaccess.cardobjects.PsoAlgorithm;
import de.gematik.ti.healthcardaccess.commands.ExternalMutualAuthenticateCommand;
import de.gematik.ti.healthcardaccess.commands.GetChallengeCommand;
import de.gematik.ti.healthcardaccess.commands.InternalAuthenticateCommand;
import de.gematik.ti.healthcardaccess.commands.ManageSecurityEnvironmentCommand;
import de.gematik.ti.healthcardaccess.commands.PsoVerifyCertificateCommand;
import de.gematik.ti.healthcardaccess.commands.ReadCommand;
import de.gematik.ti.healthcardaccess.commands.SelectCommand;
import de.gematik.ti.healthcardaccess.commands.VerifyCommand;
import de.gematik.ti.healthcardaccess.healthcards.Egk2;
import de.gematik.ti.healthcardaccess.healthcards.Egk21;
import de.gematik.ti.healthcardaccess.healthcards.HealthCardStatusValid;
import de.gematik.ti.healthcardaccess.operation.ResultOperation;
import de.gematik.ti.healthcardaccess.result.Response;
import de.gematik.ti.utils.primitives.Bytes;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardToCardAuthExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(CardToCardAuthExecutor.class);
    private static ResultOperation<Response> result;

    public static ResultOperation<C2CSuccessState> authenticateC2C(IHealthCard eGK, IHealthCard authCard) {
        IHealthCardType cardType;
        if (eGK == null || authCard == null) {
            throw new CardToCardProcessException("targetCard " + eGK + " and sourceCard " + authCard + " must not be 'null' for CardToCard-process.");
        }
        if (eGK.getStatus().isValid() && !((cardType = ((HealthCardStatusValid)eGK.getStatus()).getHealthCardType()) instanceof Egk2) && !(cardType instanceof Egk21)) {
            throw new CardToCardProcessException("eGK parameter is not of Egk2 or Egk21 type");
        }
        CardToCardAuthExecutor.doSelectRoot(eGK, authCard);
        LOG.debug("starting C2C authentication");
        ResultOperation resultCardToCard = CardToCardAuthExecutor.executeAuth(authCard, null, eGK).validate(C2CSuccessState.C2C_SUCCESS::validateSuccessState);
        LOG.debug("starting C2C authentication in the reverse direction");
        resultCardToCard = resultCardToCard.flatMap(__ -> CardToCardAuthExecutor.executeAuth(eGK, null, authCard).validate(C2CSuccessState.C2C_SUCCESS::validateSuccessState));
        return resultCardToCard;
    }

    public static ResultOperation<C2CSuccessState> authenticateC2C(IHealthCard eGK, IHealthCard authCard, Format2Pin pinAuthCard) {
        IHealthCardType cardType;
        if (eGK == null || authCard == null) {
            throw new CardToCardProcessException("targetCard " + eGK + " and sourceCard " + authCard + " must not be 'null' for CardToCard-process.");
        }
        if (eGK.getStatus().isValid() && !((cardType = ((HealthCardStatusValid)eGK.getStatus()).getHealthCardType()) instanceof Egk2) && !(cardType instanceof Egk21)) {
            throw new CardToCardProcessException("eGK parameter is not of Egk2 or Egk21 type");
        }
        CardToCardAuthExecutor.doSelectRoot(eGK, authCard);
        LOG.debug("starting C2C authentication");
        ResultOperation resultCardToCard = CardToCardAuthExecutor.executeAuth(authCard, pinAuthCard, eGK).validate(C2CSuccessState.C2C_SUCCESS::validateSuccessState);
        LOG.debug("starting C2C authentication in the reverse direction");
        resultCardToCard = resultCardToCard.flatMap(__ -> CardToCardAuthExecutor.executeAuth(eGK, null, authCard).validate(C2CSuccessState.C2C_SUCCESS::validateSuccessState));
        return resultCardToCard;
    }

    private static ResultOperation<C2CSuccessState> executeAuth(IHealthCard cardInt, Format2Pin pinAuthCard, IHealthCard cardExt) {
        CardFileSystemData cardIntFs = CardFileSystemData.getCardFileSystemData(cardInt);
        CardFileSystemData cardExtFs = CardFileSystemData.getCardFileSystemData(cardExt);
        if (pinAuthCard != null) {
            CardToCardAuthExecutor.doPinVerification(cardInt, pinAuthCard, cardIntFs);
        }
        CardToCardAuthExecutor.doCACertVerification(cardInt, cardExt, cardExtFs);
        CardToCardAuthExecutor.doAutrCertVerification(cardInt, cardExt, cardExtFs);
        ResultOperation<byte[]> challengeIccsnInt = CardToCardAuthExecutor.createToken(cardInt, cardIntFs);
        CardToCardAuthExecutor.doInternalExternalAuth(cardInt, cardExt, challengeIccsnInt);
        return result.map(C2CSuccessState.C2C_SUCCESS::validateResponse);
    }

    private static void doSelectRoot(IHealthCard cardInt, IHealthCard cardExt) {
        SelectCommand selectRootCommand = new SelectCommand(false, false);
        result = selectRootCommand.executeOn(cardInt).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).flatMap(__ -> selectRootCommand.executeOn(cardExt).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)));
    }

    private static void doPinVerification(IHealthCard cardInt, Format2Pin pin, CardFileSystemData cardIntFs) {
        LOG.debug("pin: " + pin);
        result = result.flatMap(__ -> new VerifyCommand(cardIntFs.pinChRef, false, pin).executeOn(cardInt)).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0));
    }

    private static void doCACertVerification(IHealthCard cardInt, IHealthCard cardExt, CardFileSystemData cardExtFs) {
        result = result.flatMap(__ -> new ReadCommand(cardExtFs.cvcCASfid, 0).executeOn(cardExt)).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).map(Response::getResponseData).map(GemCvCertificate::new).flatMap(caCertificateFromExt -> new ManageSecurityEnvironmentCommand(ManageSecurityEnvironmentCommand.MseUseCase.KEY_SELECTION_FOR_CV_CERTIFICATE_VALIDATION, caCertificateFromExt).executeOn(cardInt).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).flatMap(__ -> new PsoVerifyCertificateCommand(caCertificateFromExt).executeOn(cardInt).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0))));
    }

    private static void doAutrCertVerification(IHealthCard cardInt, IHealthCard cardExt, CardFileSystemData cardExtFs) {
        result = result.flatMap(__ -> new ReadCommand(cardExtFs.cvcAutrSfid, 0).executeOn(cardExt)).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).map(Response::getResponseData).map(GemCvCertificate::new).flatMap(autCertificateFromExt -> new ManageSecurityEnvironmentCommand(ManageSecurityEnvironmentCommand.MseUseCase.KEY_SELECTION_FOR_CV_CERTIFICATE_VALIDATION, autCertificateFromExt).executeOn(cardInt).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).flatMap(__ -> new PsoVerifyCertificateCommand(autCertificateFromExt).executeOn(cardInt)).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).flatMap(__ -> new ManageSecurityEnvironmentCommand(ManageSecurityEnvironmentCommand.MseUseCase.KEY_SELECTION_FOR_INTERNAL_ASYMMETRIC_AUTHENTICATION, new PsoAlgorithm(PsoAlgorithm.Algorithm.AUTHENTICATE_ELC_ROLE_AUTHENTICATION), cardExtFs.key, false).executeOn(cardExt)).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).flatMap(__ -> new ManageSecurityEnvironmentCommand(ManageSecurityEnvironmentCommand.MseUseCase.KEY_SELECTION_FOR_EXTERNAL_ASYMMETRIC_AUTHENTICATION, new PsoAlgorithm(PsoAlgorithm.Algorithm.AUTHENTICATE_ELC_ROLE_CHECK), autCertificateFromExt.getHolderReference().getContents()).executeOn(cardInt)).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)));
    }

    private static ResultOperation<byte[]> createToken(IHealthCard cardInt, CardFileSystemData cardIntFs) {
        ResultOperation resultOperation = result.flatMap(__ -> new ReadCommand(cardIntFs.gdo).executeOn(cardInt).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).map(Response::getResponseData).map(gdoData -> Arrays.copyOfRange(gdoData, 4, 12)));
        return resultOperation;
    }

    private static void doInternalExternalAuth(IHealthCard cardInt, IHealthCard cardExt, ResultOperation<byte[]> challengeIccsnInt) {
        result = challengeIccsnInt.flatMap(iccSnOfEgkData -> new GetChallengeCommand(16).executeOn(cardInt).map(Response::getResponseData).map(challengeFromEgkData -> Bytes.concatNullables((byte[][])new byte[][]{challengeFromEgkData, iccSnOfEgkData}))).flatMap(a -> new InternalAuthenticateCommand(new PsoAlgorithm(PsoAlgorithm.Algorithm.AUTHENTICATE_ELC_ROLE_AUTHENTICATION), a).executeOn(cardExt)).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).map(Response::getResponseData).flatMap(cypheredAuthString -> new ExternalMutualAuthenticateCommand(new PsoAlgorithm(PsoAlgorithm.Algorithm.AUTHENTICATE_ELC_ROLE_CHECK), cypheredAuthString, false).executeOn(cardInt)).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0));
    }
}

