/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control;

import de.gematik.ti.healthcard.control.CallbackHandlePin;
import de.gematik.ti.healthcard.control.entities.PinResult;
import de.gematik.ti.healthcard.control.entities.PinType;
import de.gematik.ti.healthcard.control.entities.card.certificate.AuthenticationCertificateState;
import de.gematik.ti.healthcard.control.entities.card.pin.PinState;
import de.gematik.ti.healthcard.control.exceptions.HealthcardControlRuntimeException;
import de.gematik.ti.healthcard.control.security.PinVerifier;
import de.gematik.ti.healthcardaccess.AbstractHealthCardCommand;
import de.gematik.ti.healthcardaccess.IHealthCard;
import de.gematik.ti.healthcardaccess.cardobjects.ApplicationIdentifier;
import de.gematik.ti.healthcardaccess.cardobjects.Password;
import de.gematik.ti.healthcardaccess.cardobjects.ShortFileIdentifier;
import de.gematik.ti.healthcardaccess.commands.GetPinStatusCommand;
import de.gematik.ti.healthcardaccess.commands.ReadCommand;
import de.gematik.ti.healthcardaccess.commands.SelectCommand;
import de.gematik.ti.healthcardaccess.operation.ResultOperation;
import de.gematik.ti.healthcardaccess.result.Response;
import de.gematik.ti.openhealthcard.events.control.RequestTransmitterPinNumber;
import de.gematik.ti.openhealthcard.events.response.callbacks.IPinNumberResponseListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(CardVerifier.class);
    private final IHealthCard card;

    public CardVerifier(IHealthCard card) {
        this.card = card;
    }

    public ResultOperation<AuthenticationCertificateState> checkAuthCertificate() {
        ApplicationIdentifier aid = new ApplicationIdentifier("A000000167455349474E");
        SelectCommand selectESignCommand = new SelectCommand(aid);
        ShortFileIdentifier sfId = new ShortFileIdentifier(1);
        ReadCommand readESignCommand = new ReadCommand(sfId);
        return selectESignCommand.executeOn(this.card).flatMap(arg_0 -> this.lambda$checkAuthCertificate$0((AbstractHealthCardCommand)readESignCommand, arg_0)).map(AuthenticationCertificateState::getCertificateValidationResult);
    }

    public ResultOperation<PinResult> verifyPin(PinType pinType) {
        LOG.debug("pinType: " + (Object)((Object)pinType));
        boolean valid = this.card.getStatus().isValid();
        LOG.debug("valid: " + valid);
        boolean verifable = PinVerifier.isCardValidForVerify(this.card);
        LOG.debug("verifable: " + verifable);
        if (!valid) {
            throw new HealthcardControlRuntimeException("card is invalid");
        }
        if (!verifable) {
            throw new HealthcardControlRuntimeException("verification for card is not yet supported");
        }
        CallbackHandlePin callback = new CallbackHandlePin(this.card);
        Runnable task = () -> {
            RequestTransmitterPinNumber requestTransmitterPinNumber = new RequestTransmitterPinNumber();
            requestTransmitterPinNumber.request((IPinNumberResponseListener)callback, pinType.toString(), "Please input pin for " + (Object)((Object)pinType));
        };
        new Thread(task).start();
        return callback.call();
    }

    public ResultOperation<PinState> getPinState(Password password) {
        GetPinStatusCommand getPinStatusCommand = new GetPinStatusCommand(password, false);
        return getPinStatusCommand.executeOn(this.card).map(PinState::getPinStateResult);
    }

    public ResultOperation<Response> checkCard() {
        ApplicationIdentifier aid = new ApplicationIdentifier("D27600000102");
        SelectCommand getHcaStatusCommand = new SelectCommand(aid);
        return getHcaStatusCommand.executeOn(this.card);
    }

    private /* synthetic */ ResultOperation lambda$checkAuthCertificate$0(AbstractHealthCardCommand readESignCommand, Response __) throws Throwable {
        return readESignCommand.executeOn(this.card);
    }
}

