/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control;

import de.gematik.ti.healthcard.control.entities.CardGeneration;
import de.gematik.ti.healthcard.control.exceptions.WrongObjectSystemVersionArraySizeException;
import de.gematik.ti.healthcardaccess.entities.Version2;
import de.gematik.ti.utils.codec.Hex;

public class CardGenerationExtractor {
    private static final int RADIX_16 = 16;
    private static final int MIN_VERSION_LENGTH = 3;

    private CardGenerationExtractor() {
    }

    public static CardGeneration getCardGeneration(byte[] objectSystemVersion) {
        CardGenerationExtractor.check(objectSystemVersion);
        int major = CardGenerationExtractor.convertToInt(objectSystemVersion[0]);
        int minor = CardGenerationExtractor.convertToInt(objectSystemVersion[1]);
        int release = CardGenerationExtractor.convertToInt(objectSystemVersion[2]);
        int version = Integer.parseInt(String.format("%02d%02d%02d", major, minor, release));
        return CardGeneration.getCardGeneration(version);
    }

    public static CardGeneration getCardGeneration(Version2 version2) {
        return CardGenerationExtractor.getCardGeneration(version2.getObjectSystemVersion());
    }

    private static Integer convertToInt(byte octet) {
        return Integer.valueOf(Hex.encodeHexString((byte[])new byte[]{octet}), 16);
    }

    private static void check(byte[] objectSystemVersion) {
        if (objectSystemVersion.length != 3) {
            throw new WrongObjectSystemVersionArraySizeException();
        }
    }
}

