/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control;

import de.gematik.ti.cardreader.provider.api.ICardReader;
import de.gematik.ti.cardreader.provider.api.card.CardException;
import de.gematik.ti.cardreader.provider.api.card.ICard;
import de.gematik.ti.cardreader.provider.api.events.CardReaderDisconnectedEvent;
import de.gematik.ti.cardreader.provider.api.events.card.CardAbsentEvent;
import de.gematik.ti.cardreader.provider.api.events.card.CardPresentEvent;
import de.gematik.ti.healthcard.control.CardGenerationExtractor;
import de.gematik.ti.healthcard.control.entities.CardGeneration;
import de.gematik.ti.healthcard.control.events.healthcard.absent.AbstractHealthCardAbsentEvent;
import de.gematik.ti.healthcard.control.events.healthcard.absent.Egk21HealthCardAbsentEvent;
import de.gematik.ti.healthcard.control.events.healthcard.absent.Egk2HealthCardAbsentEvent;
import de.gematik.ti.healthcard.control.events.healthcard.absent.Hba21HealthCardAbsentEvent;
import de.gematik.ti.healthcard.control.events.healthcard.absent.Hba2HealthCardAbsentEvent;
import de.gematik.ti.healthcard.control.events.healthcard.absent.Smcb21HealthCardAbsentEvent;
import de.gematik.ti.healthcard.control.events.healthcard.absent.Smcb2HealthCardAbsentEvent;
import de.gematik.ti.healthcard.control.events.healthcard.absent.UnknownCardAbsentEvent;
import de.gematik.ti.healthcard.control.events.healthcard.present.AbstractHealthCardPresentEvent;
import de.gematik.ti.healthcard.control.events.healthcard.present.Egk21HealthCardPresentEvent;
import de.gematik.ti.healthcard.control.events.healthcard.present.Egk2HealthCardPresentEvent;
import de.gematik.ti.healthcard.control.events.healthcard.present.Hba21HealthCardPresentEvent;
import de.gematik.ti.healthcard.control.events.healthcard.present.Hba2HealthCardPresentEvent;
import de.gematik.ti.healthcard.control.events.healthcard.present.Smcb21HealthCardPresentEvent;
import de.gematik.ti.healthcard.control.events.healthcard.present.Smcb2HealthCardPresentEvent;
import de.gematik.ti.healthcard.control.events.healthcard.present.UnknownCardPresentEvent;
import de.gematik.ti.healthcardaccess.AbstractHealthCardCommand;
import de.gematik.ti.healthcardaccess.HealthCard;
import de.gematik.ti.healthcardaccess.IHealthCard;
import de.gematik.ti.healthcardaccess.IHealthCardType;
import de.gematik.ti.healthcardaccess.cardobjects.ApplicationIdentifier;
import de.gematik.ti.healthcardaccess.cardobjects.FileControlParameter;
import de.gematik.ti.healthcardaccess.cardobjects.ShortFileIdentifier;
import de.gematik.ti.healthcardaccess.commands.ReadCommand;
import de.gematik.ti.healthcardaccess.commands.SelectCommand;
import de.gematik.ti.healthcardaccess.entities.Version2;
import de.gematik.ti.healthcardaccess.healthcards.Egk2;
import de.gematik.ti.healthcardaccess.healthcards.Egk21;
import de.gematik.ti.healthcardaccess.healthcards.Hba2;
import de.gematik.ti.healthcardaccess.healthcards.Hba21;
import de.gematik.ti.healthcardaccess.healthcards.HealthCardStatusValid;
import de.gematik.ti.healthcardaccess.healthcards.Smcb2;
import de.gematik.ti.healthcardaccess.healthcards.Smcb21;
import de.gematik.ti.healthcardaccess.healthcards.Unknown;
import de.gematik.ti.healthcardaccess.operation.ResultOperation;
import de.gematik.ti.healthcardaccess.operation.Subscriber;
import de.gematik.ti.healthcardaccess.result.Response;
import de.gematik.ti.utils.codec.Hex;
import de.gematik.ti.utils.tuple.Pair;
import java.util.HashMap;
import java.util.Map;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CardDetector {
    private static final Logger LOG = LoggerFactory.getLogger(CardDetector.class);
    private static final String TAG = "CardDetector: ";
    private static CardDetector instance;
    private final Map<ICardReader, IHealthCard> healthCardMap = new HashMap<ICardReader, IHealthCard>();

    private CardDetector() {
    }

    public static CardDetector getInstance() {
        if (instance == null) {
            instance = new CardDetector();
        }
        return instance;
    }

    public static void startDetection() {
        CardDetector.getInstance().register();
    }

    public static void stopDetection() {
        CardDetector.getInstance().unregister();
    }

    private void register() {
        EventBus.getDefault().register((Object)this);
        LOG.debug("CardDetector: registered");
    }

    private void unregister() {
        EventBus.getDefault().unregister((Object)this);
        LOG.debug("CardDetector: unregistered");
    }

    @Subscribe
    public void handleCardPresentEvents(CardPresentEvent cardPresentEvent) {
        ICardReader cardReader = cardPresentEvent.getCardReader();
        LOG.debug("CardDetector: cardPresentEvent at " + cardReader.getName());
        ICard card = null;
        try {
            card = cardReader.connect();
        }
        catch (CardException e) {
            LOG.debug("Card Reader can't connect to Card. Wrong Card present?", (Throwable)e);
        }
        if (card != null) {
            this.createHealthCardWithTypeAndSendEvent(cardReader, card);
        }
    }

    private void createHealthCardWithTypeAndSendEvent(final ICardReader cardReader, ICard card) {
        final HealthCard healthCard = new HealthCard(card);
        SelectCommand selectRootCommand = new SelectCommand(false, true);
        int sfid = this.getSfid(healthCard);
        ShortFileIdentifier sfi = new ShortFileIdentifier(sfid);
        ReadCommand readVersion2 = new ReadCommand(sfi, 0);
        selectRootCommand.executeOn((IHealthCard)healthCard).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).map(Response::getResponseData).map(FileControlParameter::new).map(FileControlParameter::getApplicationIdentifier).map(ApplicationIdentifier::new).map(this::extractCardType).flatMap(arg_0 -> CardDetector.lambda$createHealthCardWithTypeAndSendEvent$1((AbstractHealthCardCommand)readVersion2, healthCard, arg_0)).subscribe((Subscriber)new Subscriber<Pair<CARD_TYPE, CardGeneration>>(){

            public void onSuccess(Pair<CARD_TYPE, CardGeneration> value) {
                CardDetector.this.sendEvent(cardReader, healthCard, (CARD_TYPE)((Object)value.left), (CardGeneration)((Object)value.right));
            }

            public void onError(Throwable t) throws RuntimeException {
                LOG.error("Error when reading CardType or Version", (Object)t.getMessage());
            }
        });
    }

    private int getSfid(HealthCard healthCard) {
        int commonSfid = 17;
        return commonSfid;
    }

    private CARD_TYPE extractCardType(ApplicationIdentifier applicationIdentifier) {
        switch (Hex.encodeHexString((byte[])applicationIdentifier.getAid())) {
            case "D2760001448000": {
                return CARD_TYPE.EGK;
            }
            case "D27600014601": {
                return CARD_TYPE.HBA;
            }
            case "D27600014606": {
                return CARD_TYPE.SMCB;
            }
        }
        return CARD_TYPE.UNKNOWN;
    }

    private boolean sendEvent(ICardReader cardReader, HealthCard healthCard, CARD_TYPE type, CardGeneration cardGeneration) {
        switch (type) {
            case EGK: {
                healthCard.setHealthCardType(this.getHealthCardTypeForEgk(cardGeneration));
                break;
            }
            case HBA: {
                healthCard.setHealthCardType(this.getHealthCardTypeHba(cardGeneration));
                break;
            }
            case SMCB: {
                healthCard.setHealthCardType(this.getHealthCardTypeSmcb(cardGeneration));
                break;
            }
            default: {
                healthCard.setHealthCardType((IHealthCardType)new Unknown());
            }
        }
        EventBus.getDefault().post((Object)this.createPresentEventForHealthCardType(cardReader, (IHealthCard)healthCard));
        LOG.debug("CardDetector: sendCardPresentEvent at " + cardReader.getName() + " " + healthCard.getStatus());
        this.healthCardMap.put(cardReader, (IHealthCard)healthCard);
        return true;
    }

    private AbstractHealthCardPresentEvent createPresentEventForHealthCardType(ICardReader cardReader, IHealthCard healthCard) {
        if (healthCard.getStatus().isValid()) {
            IHealthCardType healthCardType = ((HealthCardStatusValid)healthCard.getStatus()).getHealthCardType();
            if (healthCardType instanceof Egk2) {
                return new Egk2HealthCardPresentEvent(cardReader, healthCard);
            }
            if (healthCardType instanceof Egk21) {
                return new Egk21HealthCardPresentEvent(cardReader, healthCard);
            }
            if (healthCardType instanceof Hba2) {
                return new Hba2HealthCardPresentEvent(cardReader, healthCard);
            }
            if (healthCardType instanceof Hba21) {
                return new Hba21HealthCardPresentEvent(cardReader, healthCard);
            }
            if (healthCardType instanceof Smcb2) {
                return new Smcb2HealthCardPresentEvent(cardReader, healthCard);
            }
            if (healthCardType instanceof Smcb21) {
                return new Smcb21HealthCardPresentEvent(cardReader, healthCard);
            }
        }
        return new UnknownCardPresentEvent(cardReader, healthCard);
    }

    private IHealthCardType getHealthCardTypeSmcb(CardGeneration cardGeneration) {
        switch (cardGeneration) {
            case G2: {
                return new Smcb2();
            }
            case G2_1: {
                return new Smcb21();
            }
        }
        return null;
    }

    private IHealthCardType getHealthCardTypeHba(CardGeneration cardGeneration) {
        switch (cardGeneration) {
            case G2: {
                return new Hba2();
            }
            case G2_1: {
                return new Hba21();
            }
        }
        return null;
    }

    private IHealthCardType getHealthCardTypeForEgk(CardGeneration cardGeneration) {
        switch (cardGeneration) {
            case G2: {
                return new Egk2();
            }
            case G2_1: {
                return new Egk21();
            }
        }
        return null;
    }

    @Subscribe
    public void handleCardAbsentEvents(CardAbsentEvent cardAbsentEvent) {
        LOG.debug("CardDetector: handleCardAbsentEvents at " + cardAbsentEvent.getCardReader().getName());
        this.sendCardAbsentEvent(cardAbsentEvent.getCardReader());
    }

    private void sendCardAbsentEvent(ICardReader cardReader) {
        LOG.debug("CardDetector: sendCardAbsentEvent at " + cardReader.getName());
        if (this.healthCardMap.containsKey(cardReader)) {
            IHealthCard iHealthCard = this.healthCardMap.remove(cardReader);
            EventBus.getDefault().post((Object)this.createAbsentEventForHealthCardType(cardReader, iHealthCard));
        }
    }

    @Subscribe
    public void handleCardReaderDisconnectedEvents(CardReaderDisconnectedEvent cardReaderDisconnectedEvent) {
        LOG.debug("CardDetector: handleCardReaderDisconnectedEvents at " + cardReaderDisconnectedEvent.getCardReader().getName());
        this.sendCardAbsentEvent(cardReaderDisconnectedEvent.getCardReader());
    }

    private AbstractHealthCardAbsentEvent createAbsentEventForHealthCardType(ICardReader cardReader, IHealthCard healthCard) {
        if (healthCard.getStatus().isValid()) {
            IHealthCardType healthCardType = ((HealthCardStatusValid)healthCard.getStatus()).getHealthCardType();
            if (healthCardType instanceof Egk2) {
                return new Egk2HealthCardAbsentEvent(cardReader, healthCard);
            }
            if (healthCardType instanceof Egk21) {
                return new Egk21HealthCardAbsentEvent(cardReader, healthCard);
            }
            if (healthCardType instanceof Hba2) {
                return new Hba2HealthCardAbsentEvent(cardReader, healthCard);
            }
            if (healthCardType instanceof Hba21) {
                return new Hba21HealthCardAbsentEvent(cardReader, healthCard);
            }
            if (healthCardType instanceof Smcb2) {
                return new Smcb2HealthCardAbsentEvent(cardReader, healthCard);
            }
            if (healthCardType instanceof Smcb21) {
                return new Smcb21HealthCardAbsentEvent(cardReader, healthCard);
            }
        }
        return new UnknownCardAbsentEvent(cardReader, healthCard);
    }

    private static /* synthetic */ ResultOperation lambda$createHealthCardWithTypeAndSendEvent$1(AbstractHealthCardCommand readVersion2, HealthCard healthCard, CARD_TYPE card_type) throws Throwable {
        return readVersion2.executeOn((IHealthCard)healthCard).map(Response::getResponseData).map(Version2::fromArray).map(CardGenerationExtractor::getCardGeneration).flatMap(cardGeneration -> ResultOperation.unitRo((Object)new Pair((Object)card_type, (Object)cardGeneration)));
    }

    private static enum CARD_TYPE {
        EGK,
        HBA,
        SMCB,
        UNKNOWN;

    }
}

