/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control;

import de.gematik.ti.healthcard.control.entities.PinResult;
import de.gematik.ti.healthcard.control.entities.PinType;
import de.gematik.ti.healthcard.control.exceptions.HealthcardControlRuntimeException;
import de.gematik.ti.healthcard.control.security.PinVerifier;
import de.gematik.ti.healthcardaccess.IHealthCard;
import de.gematik.ti.healthcardaccess.operation.ResultOperation;
import de.gematik.ti.openhealthcard.events.control.CommonEventTransmitter;
import de.gematik.ti.openhealthcard.events.response.callbacks.IPinNumberResponseListener;
import de.gematik.ti.openhealthcard.events.response.entities.PinNumber;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackHandlePin
implements IPinNumberResponseListener,
Callable<ResultOperation<PinResult>> {
    private static final Logger LOG = LoggerFactory.getLogger(CallbackHandlePin.class);
    private final ArrayBlockingQueue<ResultOperation<PinResult>> queue = new ArrayBlockingQueue(1);
    private final IHealthCard card;
    private ResultOperation<PinResult> pinResultResultOperation = null;

    public CallbackHandlePin(IHealthCard card) {
        this.card = card;
    }

    @Override
    public ResultOperation<PinResult> call() {
        try {
            this.pinResultResultOperation = this.queue.take();
        }
        catch (InterruptedException e) {
            throw new HealthcardControlRuntimeException(e.toString());
        }
        return this.pinResultResultOperation;
    }

    public void handlePinNumber(PinNumber pinNumber) {
        try {
            if (this.card.getStatus().isValid()) {
                this.pinResultResultOperation = new PinVerifier(this.card).verifyPin(PinVerifier.stringToIntarray(pinNumber.getValue()), PinType.valueOf(pinNumber.getPinType()));
                this.abortRequest();
                this.queue.put(this.pinResultResultOperation);
            } else {
                LOG.error("Card is not valid");
                RuntimeException exception = new RuntimeException("Card is not valid");
                CommonEventTransmitter.postError((Exception)exception, (String)"Pin cannot be verified because card is invalid");
            }
        }
        catch (Exception e) {
            LOG.error(e.toString());
            throw new HealthcardControlRuntimeException(e.toString());
        }
    }

    public void abortRequest() {
        this.pinResultResultOperation = this.pinResultResultOperation.map(pr -> {
            if (!pr.isPinVerifiSuccess() && pr.getErrorTextByFailure() != null) {
                String failureText = pr.getErrorTextByFailure();
                LOG.debug("failureText: " + failureText);
                RuntimeException exception = new RuntimeException(failureText);
                CommonEventTransmitter.postError((Exception)exception, (String)failureText);
            }
            return pr;
        });
    }
}

