/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.cardreader.provider.pcsc.entities;

import de.gematik.ti.cardreader.provider.api.card.ICard;
import de.gematik.ti.cardreader.provider.api.card.ICardChannel;
import de.gematik.ti.cardreader.provider.api.command.ICommandApdu;
import de.gematik.ti.cardreader.provider.api.command.IResponseApdu;
import de.gematik.ti.cardreader.provider.api.command.ResponseApdu;
import de.gematik.ti.cardreader.provider.pcsc.entities.PcscCard;
import de.gematik.ti.cardreader.provider.pcsc.entities.PcscCrpRuntimeException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcscCardChannel
implements ICardChannel {
    private static final int MINIMAL_ALLOCATE = 258;
    private static final Logger LOG = LoggerFactory.getLogger(PcscCardChannel.class);
    private static final String CARDREADER_BUFFER = "cardReader_Buffer";
    private static final String CARD_MAXAPDUBUFFERSIZE = "card_maxApduBufferSize";
    private static final String CARD_MAXRESPAPDUBUFFERSIZE = "card_maxRespApduBufferSize";
    private final CardChannel javaxCardChannel;
    private int allocateLength;
    private final PcscCard pcscCard;
    private static final Map<String, Integer> bufferSizeConfig = new LinkedHashMap(){
        {
            this.put(PcscCardChannel.CARDREADER_BUFFER, 8192);
            this.put(PcscCardChannel.CARD_MAXAPDUBUFFERSIZE, 1033);
            this.put(PcscCardChannel.CARD_MAXRESPAPDUBUFFERSIZE, 65535);
        }
    };

    public PcscCardChannel(CardChannel channel, PcscCard pcscCard) {
        this.javaxCardChannel = channel;
        this.pcscCard = pcscCard;
    }

    public ICard getCard() {
        return this.pcscCard;
    }

    public int getChannelNumber() {
        return this.javaxCardChannel.getChannelNumber();
    }

    public boolean isExtendedLengthSupported() {
        return this.getMaxMessageLength() > 255 && this.getMaxResponseLength() > 255;
    }

    public int getMaxMessageLength() {
        int maxMessageLengthCardReader = bufferSizeConfig.get(CARDREADER_BUFFER);
        int maxMessageLengthCard = bufferSizeConfig.get(CARD_MAXAPDUBUFFERSIZE);
        return Math.min(maxMessageLengthCard, maxMessageLengthCardReader);
    }

    public int getMaxResponseLength() {
        int maxResponseLengthCardReader = bufferSizeConfig.get(CARDREADER_BUFFER);
        int maxResponseLengthCard = bufferSizeConfig.get(CARD_MAXRESPAPDUBUFFERSIZE);
        return Math.min(maxResponseLengthCard, maxResponseLengthCardReader);
    }

    public IResponseApdu transmit(ICommandApdu command) throws de.gematik.ti.cardreader.provider.api.card.CardException {
        try {
            if (this.allocateLength == 0) {
                this.allocateLength = 258;
            }
            ByteBuffer byteBufferResp = ByteBuffer.allocate(258);
            int validLength = this.javaxCardChannel.transmit(ByteBuffer.wrap(command.getBytes()), byteBufferResp);
            LOG.debug("validLength in Response is {}", (Object)validLength);
            byte[] validBytes = new byte[validLength];
            System.arraycopy(byteBufferResp.array(), 0, validBytes, 0, validLength);
            return new ResponseApdu(validBytes);
        }
        catch (CardException e) {
            throw new de.gematik.ti.cardreader.provider.api.card.CardException("Error " + e + " on close occurred");
        }
    }

    public void close() throws de.gematik.ti.cardreader.provider.api.card.CardException {
        try {
            if (this.javaxCardChannel.getChannelNumber() == this.pcscCard.openBasicChannel().getChannelNumber()) {
                LOG.debug("BasicChannel not closable");
            } else {
                this.javaxCardChannel.close();
            }
        }
        catch (Exception e) {
            throw new de.gematik.ti.cardreader.provider.api.card.CardException("Error " + e + " on close occurred");
        }
    }

    public void setAllocateLength(int length) {
        if (length < 258) {
            throw new PcscCrpRuntimeException("Length must not be less than " + length);
        }
        this.allocateLength = length;
    }
}

