/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.cardreader.provider.pcsc.entities;

import de.gematik.ti.cardreader.provider.api.card.Atr;
import de.gematik.ti.cardreader.provider.api.card.CardProtocol;
import de.gematik.ti.cardreader.provider.api.card.ICard;
import de.gematik.ti.cardreader.provider.api.card.ICardChannel;
import de.gematik.ti.cardreader.provider.pcsc.entities.PcscCardChannel;
import de.gematik.ti.cardreader.provider.pcsc.entities.PcscCrpRuntimeException;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcscCard
implements ICard {
    private static final Logger LOG = LoggerFactory.getLogger(PcscCard.class);
    private final Card javaxCard;

    public PcscCard(Card javaxCard) {
        this.javaxCard = javaxCard;
        if (javaxCard == null) {
            throw new PcscCrpRuntimeException("javaxCard is not available.");
        }
    }

    public ICardChannel openLogicalChannel() throws de.gematik.ti.cardreader.provider.api.card.CardException {
        try {
            CardChannel channel = this.javaxCard.openLogicalChannel();
            LOG.debug("a channel {}({}) successfully opened", (Object)channel, (Object)channel.getChannelNumber());
            return new PcscCardChannel(channel, this);
        }
        catch (CardException e) {
            throw new de.gematik.ti.cardreader.provider.api.card.CardException("Error " + e + " on openBasicChannel occurred");
        }
    }

    public ICardChannel openBasicChannel() throws de.gematik.ti.cardreader.provider.api.card.CardException {
        try {
            if (this.javaxCard.getBasicChannel() != null) {
                LOG.info("basicChannel opened already: " + this.javaxCard.getBasicChannel());
                return new PcscCardChannel(this.javaxCard.getBasicChannel(), this);
            }
            CardChannel channel = this.javaxCard.openLogicalChannel();
            PcscCard pcscCard = new PcscCard(this.javaxCard);
            PcscCardChannel pcscCardChannel = new PcscCardChannel(channel, pcscCard);
            return pcscCardChannel;
        }
        catch (CardException e) {
            throw new de.gematik.ti.cardreader.provider.api.card.CardException("Error " + e + " on openBasicChannel occurred");
        }
    }

    public CardProtocol getProtocol() {
        try {
            String protocolResult;
            switch (protocolResult = this.javaxCard.getProtocol()) {
                case "T=0": {
                    return CardProtocol.T0;
                }
                case "T=1": {
                    return CardProtocol.T1;
                }
            }
            return CardProtocol.T15;
        }
        catch (Exception e) {
            throw new PcscCrpRuntimeException("Error " + e + " on get Protocol occurred");
        }
    }

    public Atr getATR() {
        try {
            byte[] atrBytes = this.javaxCard.getATR().getBytes();
            return new Atr(atrBytes);
        }
        catch (Exception e) {
            throw new PcscCrpRuntimeException("Error " + e + " on get ATR occurred");
        }
    }

    public void disconnect(boolean reset) throws de.gematik.ti.cardreader.provider.api.card.CardException {
        try {
            this.javaxCard.disconnect(reset);
        }
        catch (CardException e) {
            throw new PcscCrpRuntimeException("Error " + e + " on disconnect occurred");
        }
    }
}

