/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.cardreader.provider.pcsc.entities;

import de.gematik.ti.cardreader.provider.api.ICardReader;
import de.gematik.ti.cardreader.provider.api.card.ICard;
import de.gematik.ti.cardreader.provider.pcsc.entities.PcscCard;
import de.gematik.ti.cardreader.provider.pcsc.entities.PcscCrpRuntimeException;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardReader
implements ICardReader {
    private static final Logger LOG = LoggerFactory.getLogger(CardReader.class);
    private final CardTerminal cardTerminal;

    public CardReader(CardTerminal cardTerminal) {
        this.cardTerminal = cardTerminal;
        if (cardTerminal == null) {
            throw new PcscCrpRuntimeException("CardTerminal is not available");
        }
    }

    public void initialize() {
    }

    public boolean isInitialized() {
        return true;
    }

    public ICard connect(String protocol) throws de.gematik.ti.cardreader.provider.api.card.CardException {
        try {
            return new PcscCard(this.cardTerminal.connect(protocol));
        }
        catch (Exception e) {
            throw new de.gematik.ti.cardreader.provider.api.card.CardException("Error " + e + " on cardTerminal.connect occurred");
        }
    }

    public ICard connect() throws de.gematik.ti.cardreader.provider.api.card.CardException {
        return this.connect("*");
    }

    public String getName() {
        return this.cardTerminal.getName();
    }

    public boolean isCardPresent() throws de.gematik.ti.cardreader.provider.api.card.CardException {
        try {
            return this.cardTerminal.isCardPresent();
        }
        catch (Exception e) {
            throw new de.gematik.ti.cardreader.provider.api.card.CardException("Error " + e + " on cardTerminal.isCardPresent() occurred");
        }
    }

    public boolean waitForCardAbsent(long timeout) throws de.gematik.ti.cardreader.provider.api.card.CardException {
        try {
            return this.cardTerminal.waitForCardAbsent(timeout);
        }
        catch (CardException e) {
            throw new de.gematik.ti.cardreader.provider.api.card.CardException("Error " + e + " on cardTerminal.waitForCardAbsent() occurred");
        }
    }

    public boolean waitForCardPresent(long timeout) throws de.gematik.ti.cardreader.provider.api.card.CardException {
        try {
            return this.cardTerminal.waitForCardPresent(timeout);
        }
        catch (CardException e) {
            throw new de.gematik.ti.cardreader.provider.api.card.CardException("Error " + e + " on cardTerminal.waitForCardAbsent(long) occurred");
        }
    }

    public String toString() {
        return this.cardTerminal.getName();
    }

    public CardTerminal getCardTerminal() {
        return this.cardTerminal;
    }
}

