/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.cardreader.provider.pcsc.control;

import de.gematik.ti.cardreader.provider.api.AbstractCardReaderController;
import de.gematik.ti.cardreader.provider.api.ICardReader;
import de.gematik.ti.cardreader.provider.api.listener.InitializationStatus;
import de.gematik.ti.cardreader.provider.pcsc.control.CardReaderCardChecker;
import de.gematik.ti.cardreader.provider.pcsc.entities.CardReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.TerminalFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PcScCardReaderController
extends AbstractCardReaderController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PcScCardReaderController.class);
    private static volatile PcScCardReaderController instance;
    private final Collection<ICardReader> readers = new ArrayList<ICardReader>();

    private PcScCardReaderController() {
        Collection<ICardReader> cardReaders = this.findAvailableCardReaders();
        this.readers.addAll(cardReaders);
        new CheckReaders().start();
    }

    public static PcScCardReaderController getInstance() {
        if (instance == null) {
            instance = new PcScCardReaderController();
        }
        return instance;
    }

    public Collection<ICardReader> getCardReaders() {
        return this.readers;
    }

    private Collection<ICardReader> findAvailableCardReaders() {
        TerminalFactory factory = TerminalFactory.getDefault();
        return this.listCardReaders(factory);
    }

    private Collection<ICardReader> listCardReaders(TerminalFactory factory) {
        List<CardTerminal> list;
        try {
            list = factory.terminals().list();
        }
        catch (Exception e) {
            list = new ArrayList<CardTerminal>();
            LOGGER.info(String.valueOf(e));
        }
        return list.stream().map(ct -> new CardReader((CardTerminal)ct)).collect(Collectors.toList());
    }

    class CheckReaders
    extends Thread {
        private static final int SLEEP_BETWEEN_READERS_CHECK = 1000;
        private final Map<CardReader, CardReaderCardChecker> cardCheckerMap = new HashMap<CardReader, CardReaderCardChecker>();

        CheckReaders() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            super.run();
            while (true) {
                try {
                    while (true) {
                        Collection cardReaders = PcScCardReaderController.this.findAvailableCardReaders();
                        this.findNewAndInform(cardReaders);
                        this.findRemovedAndInform(cardReaders);
                        PcScCardReaderController.this.readers.clear();
                        PcScCardReaderController.this.readers.addAll(cardReaders);
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.warn("InterruptedException by read PCSC-CardReader", (Throwable)e);
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }

        private void findNewAndInform(Collection<ICardReader> cardReaders) {
            ArrayList<ICardReader> cardReadersNewRead = new ArrayList<ICardReader>(cardReaders);
            Predicate<ICardReader> ctPredicate = ct -> PcScCardReaderController.this.readers.stream().anyMatch(ct2 -> ct2.getName().equals(ct.getName()));
            cardReadersNewRead.removeIf(ctPredicate);
            cardReadersNewRead.forEach(ct -> PcScCardReaderController.this.informAboutReaderConnection(ct, InitializationStatus.INIT_SUCCESS));
            cardReadersNewRead.forEach(ct -> this.createNewChecker((CardReader)ct));
        }

        private void findRemovedAndInform(Collection<ICardReader> cardReaders) {
            ArrayList<ICardReader> cardReadersToRemove = new ArrayList<ICardReader>(PcScCardReaderController.this.readers);
            Predicate<ICardReader> ctPredicate = ct -> cardReaders.stream().anyMatch(ct2 -> ct2.getName().equals(ct.getName()));
            cardReadersToRemove.removeIf(ctPredicate);
            cardReadersToRemove.forEach(ct -> this.stopChecker((CardReader)ct));
            cardReadersToRemove.forEach(ct -> PcScCardReaderController.this.informAboutReaderDisconnection(ct));
        }

        private void createNewChecker(CardReader cardReader) {
            this.cardCheckerMap.put(cardReader, CardReaderCardChecker.startNewInstance(cardReader));
        }

        private void stopChecker(CardReader cardReader) {
            if (this.cardCheckerMap.containsKey(cardReader)) {
                this.cardCheckerMap.remove(cardReader).stopChecker();
            }
        }
    }
}

