/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.cardreader.provider.pcsc.control;

import de.gematik.ti.cardreader.provider.api.AbstractCardReaderController;
import de.gematik.ti.cardreader.provider.api.ICardReader;
import de.gematik.ti.cardreader.provider.api.card.CardException;
import de.gematik.ti.cardreader.provider.pcsc.control.PcScCardReaderController;
import de.gematik.ti.cardreader.provider.pcsc.entities.CardReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardReaderCardChecker
extends Thread {
    private static final int WAIT_FOR_CARD_EVENT = 1000;
    private static final Logger LOGGER = LoggerFactory.getLogger(CardReaderCardChecker.class);
    private volatile boolean physicalReaderAvailable = true;
    private final CardReader cardReader;
    private boolean active = false;
    private final AbstractCardReaderController cardReaderController;

    public CardReaderCardChecker(CardReader cardReader) {
        this.cardReader = cardReader;
        this.cardReaderController = PcScCardReaderController.getInstance();
    }

    public static CardReaderCardChecker startNewInstance(CardReader cardReader) {
        CardReaderCardChecker newInstance = new CardReaderCardChecker(cardReader);
        newInstance.start();
        return newInstance;
    }

    @Override
    public void run() {
        super.run();
        this.doCheckCards();
    }

    private void doCheckCards() {
        this.active = true;
        LOGGER.info("Start CardReaderCardChecker");
        boolean state = false;
        try {
            state = this.cardReader.isCardPresent();
            LOGGER.debug("state: " + state);
        }
        catch (CardException e) {
            LOGGER.debug("Error by request current card status at card reader " + this.cardReader, (Throwable)e);
        }
        if (state) {
            this.cardReaderController.createCardEventTransmitter((ICardReader)this.cardReader).informAboutCardPresent();
        }
        LOGGER.debug("initial State: " + state);
        while (this.physicalReaderAvailable) {
            try {
                if (state) {
                    boolean cardAbsent = this.cardReader.waitForCardAbsent(1000L);
                    LOGGER.trace("cardAbsent: " + cardAbsent);
                } else {
                    boolean cardPresent = this.cardReader.waitForCardPresent(1000L);
                    LOGGER.trace("cardPresent: " + cardPresent);
                }
                if (!this.physicalReaderAvailable) {
                    LOGGER.debug("physicalReaderAvailable: " + this.physicalReaderAvailable);
                    return;
                }
                if (this.cardReader.isCardPresent() == state) continue;
                state = this.cardReader.isCardPresent();
                this.sendCardMessageForState(state);
                LOGGER.trace("sendCardMessageForState: " + state);
            }
            catch (CardException e) {
                LOGGER.error("Error by request current card status at card reader " + this.cardReader, (Throwable)e);
            }
        }
        this.active = false;
    }

    protected void sendCardMessageForState(boolean state) {
        if (state) {
            this.cardReaderController.createCardEventTransmitter((ICardReader)this.cardReader).informAboutCardPresent();
        } else {
            this.cardReaderController.createCardEventTransmitter((ICardReader)this.cardReader).informAboutCardAbsent();
        }
    }

    public void stopChecker() {
        this.physicalReaderAvailable = false;
    }

    public boolean isActive() {
        return this.active;
    }
}

