/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelValueFacet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ByteArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.api.StringAssert;

public class RbelElementAssertion
extends AbstractAssert<RbelElementAssertion, RbelElement> {
    private RbelElement initial;

    public RbelElementAssertion(RbelElement actual) {
        super((Object)actual, RbelElementAssertion.class);
        this.initial = actual;
    }

    private RbelElementAssertion(RbelElement actual, RbelElement initial) {
        super((Object)actual, RbelElementAssertion.class);
        this.initial = initial;
    }

    public static RbelElementAssertion assertThat(RbelElement actual) {
        return new RbelElementAssertion(actual);
    }

    public RbelElementAssertion extractChildWithPath(String rbelPath) {
        List kids = ((RbelElement)this.actual).findRbelPathMembers(rbelPath);
        if (kids.isEmpty()) {
            this.failWithMessage("Expected rbelPath %s to find member, but did not in tree %s", new Object[]{rbelPath, ((RbelElement)this.actual).printTreeStructureWithoutColors()});
        }
        if (kids.size() > 1) {
            this.failWithMessage("Expected rbelPath %s to find one member, but did return %s in tree %s", new Object[]{rbelPath, kids.size(), ((RbelElement)this.actual).printTreeStructureWithoutColors()});
        }
        return new RbelElementAssertion((RbelElement)kids.get(0), (RbelElement)this.actual);
    }

    public RbelElementAssertion hasChildWithPath(String rbelPath) {
        this.extractChildWithPath(rbelPath);
        return this;
    }

    public RbelElementAssertion doesNotHaveChildWithPath(String rbelPath) {
        List kids = ((RbelElement)this.actual).findRbelPathMembers(rbelPath);
        if (!kids.isEmpty()) {
            this.failWithMessage("Expected rbelPath $s not to find anything, but found %s", new Object[]{rbelPath, kids});
        }
        return (RbelElementAssertion)this.myself;
    }

    public RbelElementAssertion andTheInitialElement() {
        return new RbelElementAssertion(this.initial);
    }

    public RbelElementAssertion hasStringContentEqualTo(String expectedToString) {
        this.objects.assertHasToString((AssertionInfo)this.info, (Object)((RbelElement)this.actual).getRawStringContent(), expectedToString);
        return (RbelElementAssertion)this.myself;
    }

    public RbelElementAssertion hasNullContent() {
        if (((RbelElement)this.actual).getRawContent() != null) {
            this.failWithMessage("Expecting null content, but found %s", new Object[]{((RbelElement)this.actual).getRawStringContent()});
        }
        return (RbelElementAssertion)this.myself;
    }

    public StringAssert asString() {
        return new StringAssert(((RbelElement)this.actual).getRawStringContent());
    }

    public ByteArrayAssert getContent() {
        return new ByteArrayAssert(((RbelElement)this.actual).getRawContent());
    }

    public OptionalAssert<String> valueAsString() {
        return AssertionsForClassTypes.assertThat((Optional)((RbelElement)this.actual).printValue());
    }

    public RbelElementAssertion hasFacet(Class<? extends RbelFacet> facetToTest) {
        if (!((RbelElement)this.actual).hasFacet(facetToTest)) {
            this.failWithMessage("Expecting element to have facet of type %s, but only found facets %s", new Object[]{facetToTest.getSimpleName(), new ArrayList(((RbelElement)this.actual).getFacets())});
        }
        return (RbelElementAssertion)this.myself;
    }

    public RbelElementAssertion doesNotHaveFacet(Class<? extends RbelFacet> facetToTest) {
        if (((RbelElement)this.actual).hasFacet(facetToTest)) {
            this.failWithMessage("Expecting element to have NOT facet of type %s, but it was found along with %s", new Object[]{facetToTest.getSimpleName(), new ArrayList(((RbelElement)this.actual).getFacets())});
        }
        return (RbelElementAssertion)this.myself;
    }

    public RbelElementAssertion hasValueEqualTo(Object expected) {
        this.hasFacet(RbelValueFacet.class);
        Object actualValue = ((RbelValueFacet)((RbelElement)this.actual).getFacetOrFail(RbelValueFacet.class)).getValue();
        if (!expected.equals(actualValue)) {
            this.failWithMessage("Expecting element to have value of %s, but found %s instead", new Object[]{expected, actualValue});
        }
        return (RbelElementAssertion)this.myself;
    }

    public <F extends RbelFacet> ObjectAssert<F> extractFacet(Class<F> facetClass) {
        if (!((RbelElement)this.actual).hasFacet(facetClass)) {
            this.failWithMessage("Expecting element to have facet of type %s, but only found facets %s", new Object[]{facetClass.getSimpleName(), new ArrayList(((RbelElement)this.actual).getFacets())});
        }
        return new ObjectAssert((Object)((RbelElement)this.actual).getFacetOrFail(facetClass));
    }
}

