/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.test.tiger.proxy.AbstractTigerProxy;
import de.gematik.test.tiger.proxy.MockServerToRbelConverter;
import de.gematik.test.tiger.proxy.TigerKeyAndCertificateFactoryInjector;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.configuration.TigerProxyConfiguration;
import de.gematik.test.tiger.proxy.data.TigerRoute;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyConfigurationException;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyRouteConflictException;
import java.security.Provider;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.mockserver.client.MockServerClient;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.mock.Expectation;
import org.mockserver.model.ExpectationId;
import org.mockserver.model.Header;
import org.mockserver.model.HttpOverrideForwardedRequest;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.RequestDefinition;
import org.mockserver.netty.MockServer;
import org.mockserver.proxyconfiguration.ProxyConfiguration;
import org.mockserver.socket.tls.NettySslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wiremock.org.eclipse.jetty.util.URIUtil;

public class TigerProxy
extends AbstractTigerProxy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerProxy.class);
    private MockServer mockServer;
    private MockServerClient mockServerClient;
    private MockServerToRbelConverter mockServerToRbelConverter;
    private Map<String, TigerRoute> tigerRouteMap = new HashMap<String, TigerRoute>();

    public TigerProxy(TigerProxyConfiguration configuration) {
        super(configuration);
        if (configuration.getServerRootCa() != null) {
            TigerKeyAndCertificateFactoryInjector.injectIntoMockServer(configuration);
        } else {
            if (StringUtils.isNotEmpty((CharSequence)configuration.getServerRootCaCertPem())) {
                log.info("Changing CA to file {}", (Object)configuration.getServerRootCaCertPem());
                ConfigurationProperties.certificateAuthorityCertificate((String)configuration.getServerRootCaCertPem());
            }
            if (StringUtils.isNotEmpty((CharSequence)configuration.getServerRootCaKeyPem())) {
                log.info("Changing CA-key to file {}", (Object)configuration.getServerRootCaKeyPem());
                ConfigurationProperties.certificateAuthorityPrivateKey((String)configuration.getServerRootCaKeyPem());
            }
        }
        this.mockServerToRbelConverter = new MockServerToRbelConverter(this.getRbelLogger());
        ConfigurationProperties.useBouncyCastleForKeyAndCertificateGeneration((boolean)true);
        if (StringUtils.isNotEmpty((CharSequence)configuration.getProxyLogLevel())) {
            ConfigurationProperties.logLevel((String)configuration.getProxyLogLevel());
        }
        NettySslContextFactory.clientSslContextBuilderFunction = sslContextBuilder -> {
            try {
                sslContextBuilder.sslContextProvider((Provider)new BouncyCastleJsseProvider());
                return sslContextBuilder.build();
            }
            catch (SSLException e) {
                throw new RuntimeException(e);
            }
        };
        this.mockServer = this.convertProxyConfiguration(configuration).map(proxyConfiguration -> new MockServer(proxyConfiguration, configuration.getPortAsArray())).orElseGet(() -> new MockServer(configuration.getPortAsArray()));
        log.info("Proxy started on port " + this.mockServer.getLocalPort());
        this.mockServerClient = new MockServerClient("localhost", this.mockServer.getLocalPort());
        if (configuration.getProxyRoutes() != null) {
            for (TigerRoute tigerRoute : configuration.getProxyRoutes()) {
                this.addRoute(tigerRoute);
            }
        }
        if (configuration.isActivateRbelEndpoint()) {
            this.mockServerClient.when((RequestDefinition)HttpRequest.request().withHeader("Host", new String[]{"rbel"})).respond(HttpResponse.response().withHeader("content-type", new String[]{"text/html; charset=utf-8"}).withBody(new RbelHtmlRenderer().doRender(this.getRbelLogger().getMessageHistory())));
            this.mockServerClient.when((RequestDefinition)HttpRequest.request().withHeader("Host", null).withPath("/rbel")).respond(httpRequest -> HttpResponse.response().withHeader("content-type", new String[]{"text/html; charset=utf-8"}).withBody(new RbelHtmlRenderer().doRender(this.getRbelLogger().getMessageHistory())));
        }
        Optional.of(configuration).filter(Objects::nonNull).map(TigerProxyConfiguration::getTrafficEndpoints).filter(Objects::nonNull).stream().flatMap(Collection::stream).map(url -> new TigerRemoteProxyClient((String)url, new TigerProxyConfiguration())).forEach(remoteClient -> {
            remoteClient.setRbelLogger(this.getRbelLogger());
            remoteClient.addRbelMessageListener(this::triggerListener);
        });
    }

    private Optional<ProxyConfiguration> convertProxyConfiguration(TigerProxyConfiguration configuration) {
        if (configuration.getForwardToProxy() == null || StringUtils.isEmpty((CharSequence)configuration.getForwardToProxy().getHostname())) {
            return Optional.empty();
        }
        return Optional.of(ProxyConfiguration.proxyConfiguration((ProxyConfiguration.Type)ProxyConfiguration.Type.HTTPS, (String)(configuration.getForwardToProxy().getHostname() + ":" + configuration.getForwardToProxy().getPort())));
    }

    @Override
    public String getBaseUrl() {
        return "http://localhost:" + this.mockServer.getLocalPort();
    }

    @Override
    public int getPort() {
        return this.mockServer.getLocalPort();
    }

    @Override
    public List<TigerRoute> getRoutes() {
        return this.tigerRouteMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public TigerRoute addRoute(TigerRoute tigerRoute) {
        this.tigerRouteMap.values().stream().filter(existingRoute -> URIUtil.equalsIgnoreEncodings((String)existingRoute.getFrom(), (String)tigerRoute.getFrom())).findAny().ifPresent(existingRoute -> {
            throw new TigerProxyRouteConflictException((TigerRoute)existingRoute);
        });
        log.info("adding route {} -> {}", (Object)tigerRoute.getFrom(), (Object)tigerRoute.getTo());
        Expectation[] expectations = this.mockServerClient.when((RequestDefinition)HttpRequest.request().withHeader("Host", new String[]{tigerRoute.getFrom().split("://")[1]}).withSecure(Boolean.valueOf(tigerRoute.getFrom().startsWith("https://")))).forward(req -> HttpOverrideForwardedRequest.forwardOverriddenRequest((HttpRequest)req.replaceHeader(Header.header((String)"Host", (String[])new String[]{tigerRoute.getTo().split("://")[1]}))).getHttpRequest().withSecure(Boolean.valueOf(tigerRoute.getTo().startsWith("https://"))), (req, resp) -> {
            if (!tigerRoute.isDisableRbelLogging()) {
                try {
                    this.triggerListener(this.mockServerToRbelConverter.convertRequest(req, tigerRoute.getFrom()));
                    this.triggerListener(this.mockServerToRbelConverter.convertResponse(resp, tigerRoute.getFrom()));
                }
                catch (Exception e) {
                    log.error("RBel FAILED!", (Throwable)e);
                }
            }
            return resp;
        });
        if (expectations.length > 1) {
            log.warn("Unexpected number of expectations created! Got {}, expected 1", (Object)expectations.length);
        }
        if (expectations.length == 0) {
            throw new TigerProxyConfigurationException("Error while adding route from '{}' to '{}': Got 0 new expectations");
        }
        tigerRoute.setId(expectations[0].getId());
        this.tigerRouteMap.put(expectations[0].getId(), tigerRoute);
        return tigerRoute;
    }

    @Override
    public void removeRoute(String routeId) {
        this.mockServerClient.clear(new ExpectationId().withId(routeId));
        TigerRoute route = this.tigerRouteMap.remove(routeId);
        log.info("Deleted route {}. Current # expectations {}", (Object)route, (Object)this.mockServerClient.retrieveActiveExpectations((RequestDefinition)HttpRequest.request()).length);
    }
}

