/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.rbellogger.util.RbelPkiIdentity;
import de.gematik.test.tiger.proxy.configuration.TigerProxyConfiguration;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import java.util.Random;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.IPAddress;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.tls.bouncycastle.BCKeyAndCertificateFactory;
import org.mockserver.socket.tls.jdk.CertificateSigningRequest;
import org.slf4j.event.Level;

public class TigerKeyAndCertificateFactory
extends BCKeyAndCertificateFactory {
    private final MockServerLogger mockServerLogger;
    private final RbelPkiIdentity caIdentity;
    private RbelPkiIdentity eeIdentity;

    public TigerKeyAndCertificateFactory(MockServerLogger mockServerLogger, TigerProxyConfiguration tigerProxyConfiguration) {
        super(mockServerLogger);
        this.mockServerLogger = mockServerLogger;
        this.caIdentity = tigerProxyConfiguration.getServerRootCa();
    }

    public boolean certificateAuthorityCertificateNotYetCreated() {
        return false;
    }

    public X509Certificate certificateAuthorityX509Certificate() {
        return this.caIdentity.getCertificate();
    }

    public PrivateKey privateKey() {
        return this.eeIdentity.getPrivateKey();
    }

    public X509Certificate x509Certificate() {
        return this.eeIdentity.getCertificate();
    }

    public void buildAndSavePrivateKeyAndX509Certificate() {
        try {
            KeyPair keyPair = this.generateRsaKeyPair(2048);
            X509Certificate x509Certificate = this.createCertificateSignedByCa(keyPair.getPublic(), this.caIdentity.getCertificate(), this.caIdentity.getPrivateKey(), this.caIdentity.getCertificate().getPublicKey(), ConfigurationProperties.sslCertificateDomainName(), ConfigurationProperties.sslSubjectAlternativeNameDomains(), ConfigurationProperties.sslSubjectAlternativeNameIps());
            this.eeIdentity = new RbelPkiIdentity(x509Certificate, keyPair.getPrivate(), Optional.empty());
            if (MockServerLogger.isEnabled((Level)Level.TRACE)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("created new X509{}with SAN Domain Names{}and IPs{}").setArguments(new Object[]{this.x509Certificate(), Arrays.toString(ConfigurationProperties.sslSubjectAlternativeNameDomains()), Arrays.toString(ConfigurationProperties.sslSubjectAlternativeNameIps())}));
            }
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while generating private key and X509 certificate").setThrowable((Throwable)e));
        }
    }

    private X509Certificate createCertificateSignedByCa(PublicKey publicKey, X509Certificate certificateAuthorityCert, PrivateKey certificateAuthorityPrivateKey, PublicKey certificateAuthorityPublicKey, String domain, String[] subjectAlternativeNameDomains, String[] subjectAlternativeNameIps) throws Exception {
        X500Name issuer = new X509CertificateHolder(certificateAuthorityCert.getEncoded()).getSubject();
        X500Name subject = new X500Name("CN=" + domain + ", O=Gematik, L=Berlin, ST=Berlin, C=DE");
        BigInteger serial = BigInteger.valueOf(new Random().nextInt(Integer.MAX_VALUE));
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuer, serial, CertificateSigningRequest.NOT_BEFORE, CertificateSigningRequest.NOT_AFTER, subject, publicKey);
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)this.createNewSubjectKeyIdentifier(publicKey));
        builder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
        ArrayList<GeneralName> subjectAlternativeNames = new ArrayList<GeneralName>();
        if (subjectAlternativeNameDomains != null) {
            subjectAlternativeNames.add(new GeneralName(2, domain));
            for (String subjectAlternativeNameDomain : subjectAlternativeNameDomains) {
                subjectAlternativeNames.add(new GeneralName(2, subjectAlternativeNameDomain));
            }
        }
        if (subjectAlternativeNameIps != null) {
            for (String subjectAlternativeNameIp : subjectAlternativeNameIps) {
                if (!IPAddress.isValidIPv6WithNetmask((String)subjectAlternativeNameIp) && !IPAddress.isValidIPv6((String)subjectAlternativeNameIp) && !IPAddress.isValidIPv4WithNetmask((String)subjectAlternativeNameIp) && !IPAddress.isValidIPv4((String)subjectAlternativeNameIp)) continue;
                subjectAlternativeNames.add(new GeneralName(7, subjectAlternativeNameIp));
            }
        }
        if (subjectAlternativeNames.size() > 0) {
            DERSequence subjectAlternativeNamesExtension = new DERSequence(subjectAlternativeNames.toArray(new ASN1Encodable[0]));
            builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAlternativeNamesExtension);
        }
        X509Certificate signedX509Certificate = this.signTheCertificate((X509v3CertificateBuilder)builder, certificateAuthorityPrivateKey);
        signedX509Certificate.checkValidity(new Date());
        signedX509Certificate.verify(certificateAuthorityPublicKey);
        return signedX509Certificate;
    }

    private X509Certificate signTheCertificate(X509v3CertificateBuilder certificateBuilder, PrivateKey privateKey) throws OperatorCreationException, CertificateException {
        if (privateKey instanceof RSAPrivateKey) {
            ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider("BC").build(privateKey);
            return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateBuilder.build(signer));
        }
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withECDSA").setProvider("BC").build(privateKey);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateBuilder.build(signer));
    }

    private KeyPair generateRsaKeyPair(int keySize) throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "BC");
        generator.initialize(keySize, new SecureRandom());
        return generator.generateKeyPair();
    }

    private SubjectKeyIdentifier createNewSubjectKeyIdentifier(Key key) throws IOException {
        try (ASN1InputStream is = new ASN1InputStream((InputStream)new ByteArrayInputStream(key.getEncoded()));){
            ASN1Sequence seq = (ASN1Sequence)is.readObject();
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)seq);
            SubjectKeyIdentifier subjectKeyIdentifier = new BcX509ExtensionUtils().createSubjectKeyIdentifier(info);
            return subjectKeyIdentifier;
        }
    }

    public boolean certificateNotYetCreated() {
        return this.eeIdentity == null;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

