/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.RbelMessage;
import de.gematik.rbellogger.data.elements.RbelBinaryElement;
import de.gematik.rbellogger.data.elements.RbelElement;
import de.gematik.rbellogger.data.elements.RbelHttpRequest;
import de.gematik.rbellogger.data.elements.RbelHttpResponse;
import de.gematik.rbellogger.data.elements.RbelMultiValuedMapElement;
import de.gematik.rbellogger.data.elements.RbelNullElement;
import de.gematik.rbellogger.data.elements.RbelStringElement;
import de.gematik.rbellogger.data.elements.RbelUriElement;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import lombok.Generated;
import org.mockserver.mappers.MockServerHttpRequestToFullHttpRequest;
import org.mockserver.mappers.MockServerHttpResponseToFullHttpResponse;
import org.mockserver.model.Body;
import org.mockserver.model.Header;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.MediaType;

public class MockServerToRbelConverter {
    private final RbelLogger rbelLogger;

    public RbelMessage convertResponse(HttpResponse response, String protocolAndHost) {
        RbelHttpResponse rbelHttpResponse = (RbelHttpResponse)this.convertMessage(RbelHttpResponse.builder().responseCode(response.getStatusCode().intValue()).header(this.mapHeader(response.getHeaders())).body(this.convertBody((Body)response.getBody(), response.getHeaders())).rawBody(response.getBodyAsRawBytes()).build().setRawMessage(this.buildOriginalContent(response)));
        RbelMessage rbelMessage = this.rbelLogger.getRbelConverter().parseMessage((RbelElement)rbelHttpResponse, RbelHostname.generateFromUrl((String)protocolAndHost), null);
        return rbelMessage;
    }

    private RbelElement convertBody(Body body, Headers headers) {
        if (body == null || body.getRawBytes() == null || body.getRawBytes().length == 0) {
            return new RbelNullElement();
        }
        if (headers.getValues("Content-Type").stream().filter(v -> v.startsWith(MediaType.APPLICATION_BINARY.toString()) || v.startsWith(MediaType.APPLICATION_OCTET_STREAM.toString())).findAny().isPresent()) {
            return this.convertMessage((RbelElement)new RbelBinaryElement(body.getRawBytes()));
        }
        return this.rbelLogger.getRbelConverter().convertElement(new String(body.getRawBytes()));
    }

    private RbelElement convertMessage(RbelElement input) {
        return this.rbelLogger.getRbelConverter().convertElement(input);
    }

    public RbelMessage convertRequest(HttpRequest request, String protocolAndHost) {
        RbelHttpRequest rbelHttpRequest = (RbelHttpRequest)this.convertMessage(RbelHttpRequest.builder().method(request.getMethod().getValue()).path((RbelUriElement)this.rbelLogger.getRbelConverter().convertElement(this.buildOriginalRequestUri(request, protocolAndHost))).header(this.mapHeader(request.getHeaders())).body(this.convertBody(request.getBody(), request.getHeaders())).rawBody(request.getBodyAsRawBytes()).build().setRawMessage(this.buildOriginalContent(request)));
        RbelMessage rbelMessage = this.rbelLogger.getRbelConverter().parseMessage((RbelElement)rbelHttpRequest, null, RbelHostname.generateFromUrl((String)protocolAndHost));
        return rbelMessage;
    }

    private String buildOriginalRequestUri(HttpRequest request, String protocolAndHost) {
        return protocolAndHost + new MockServerHttpRequestToFullHttpRequest(null).mapMockServerRequestToNettyRequest(request).uri();
    }

    private String buildOriginalContent(HttpRequest request) {
        return new MockServerHttpRequestToFullHttpRequest(null).mapMockServerRequestToNettyRequest(request).toString().split("\\n", 2)[1];
    }

    private String buildOriginalContent(HttpResponse response) {
        String str = new MockServerHttpResponseToFullHttpResponse(null).mapMockServerResponseToNettyResponse(response).toString().split("\\n", 2)[1];
        return str.substring(0, str.length() - 1);
    }

    private RbelMultiValuedMapElement mapHeader(Headers headers) {
        RbelMultiValuedMapElement result = new RbelMultiValuedMapElement(new HashMap());
        for (Header entry : headers.getEntries()) {
            entry.getValues().forEach(str -> result.put(entry.getName().getValue(), (RbelElement)new RbelStringElement(str.getValue())));
        }
        return result;
    }

    @ConstructorProperties(value={"rbelLogger"})
    @Generated
    public MockServerToRbelConverter(RbelLogger rbelLogger) {
        this.rbelLogger = rbelLogger;
    }

    @Generated
    public RbelLogger getRbelLogger() {
        return this.rbelLogger;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MockServerToRbelConverter)) {
            return false;
        }
        MockServerToRbelConverter other = (MockServerToRbelConverter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RbelLogger this$rbelLogger = this.getRbelLogger();
        RbelLogger other$rbelLogger = other.getRbelLogger();
        return !(this$rbelLogger == null ? other$rbelLogger != null : !this$rbelLogger.equals(other$rbelLogger));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MockServerToRbelConverter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelLogger $rbelLogger = this.getRbelLogger();
        result = result * 59 + ($rbelLogger == null ? 43 : $rbelLogger.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MockServerToRbelConverter(rbelLogger=" + this.getRbelLogger() + ")";
    }
}

