/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelUriFacet;
import de.gematik.rbellogger.data.facet.RbelUriParameterFacet;
import de.gematik.test.tiger.common.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.proxy.TigerProxy;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.mockserver.mock.action.ExpectationForwardAndResponseCallback;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTigerRouteCallback
implements ExpectationForwardAndResponseCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractTigerRouteCallback.class);
    private final TigerProxy tigerProxy;
    private final TigerRoute tigerRoute;

    public void applyModifications(HttpRequest request) {
        RbelElement requestElement = this.tigerProxy.getMockServerToRbelConverter().requestToRbelMessage(request);
        RbelElement modifiedRequest = this.tigerProxy.getRbelLogger().getRbelModifier().applyModifications(requestElement);
        if (modifiedRequest == requestElement) {
            return;
        }
        request.withBody(((RbelElement)modifiedRequest.findElement("$.body").get()).getRawContent());
        for (RbelElement modifiedHeader : modifiedRequest.findRbelPathMembers("$.header.*")) {
            request = request.replaceHeader(Header.header((String)((String)modifiedHeader.getKey().orElseThrow()), (String[])new String[]{modifiedHeader.getRawStringContent()}));
        }
        RbelUriFacet uriFacet = (RbelUriFacet)((RbelElement)modifiedRequest.findElement("$.path").get()).getFacetOrFail(RbelUriFacet.class);
        request.withPath(uriFacet.getBasicPathString());
        this.clearExistingQueryParameters(request);
        this.addAllQueryParametersFromRbelMessage(request, uriFacet);
        request.withMethod(((RbelElement)modifiedRequest.findElement("$.method").get()).getRawStringContent());
    }

    private void addAllQueryParametersFromRbelMessage(HttpRequest request, RbelUriFacet uriFacet) {
        for (RbelElement queryElement : uriFacet.getQueryParameters()) {
            RbelUriParameterFacet parameterFacet = (RbelUriParameterFacet)queryElement.getFacetOrFail(RbelUriParameterFacet.class);
            request.withQueryStringParameter(parameterFacet.getKeyAsString(), new String[]{parameterFacet.getValue().getRawStringContent()});
        }
    }

    private void clearExistingQueryParameters(HttpRequest request) {
        Parameters queryStringParameters = request.getQueryStringParameters();
        if (queryStringParameters == null) {
            return;
        }
        queryStringParameters.getEntries().stream().forEach(parameter -> queryStringParameters.remove(parameter.getName()));
    }

    public void applyModifications(HttpResponse response) {
        RbelElement responseElement = this.tigerProxy.getMockServerToRbelConverter().responseToRbelMessage(response);
        RbelElement modifiedResponse = this.tigerProxy.getRbelLogger().getRbelModifier().applyModifications(responseElement);
        if (modifiedResponse == responseElement) {
            return;
        }
        response.withBody(((RbelElement)modifiedResponse.findElement("$.body").get()).getRawContent());
        for (RbelElement modifiedHeader : modifiedResponse.findRbelPathMembers("$.header.*")) {
            response = response.replaceHeader(Header.header((String)((String)modifiedHeader.getKey().orElseThrow()), (String[])new String[]{modifiedHeader.getRawStringContent()}));
        }
        response.withStatusCode(Integer.valueOf(Integer.parseInt(((RbelElement)modifiedResponse.findElement("$.responseCode").get()).getRawStringContent())));
    }

    public final HttpRequest handle(HttpRequest req) {
        try {
            return this.handleRequest(req);
        }
        catch (RuntimeException e) {
            this.propagateExceptionMessageSafe(e);
            throw e;
        }
    }

    public void propagateExceptionMessageSafe(Exception exception) {
        try {
            this.tigerProxy.propagateException(exception);
        }
        catch (Exception handlingException) {
            log.warn("While propagating an exception another error occured (ignoring):", (Throwable)handlingException);
        }
    }

    protected abstract HttpRequest handleRequest(HttpRequest var1);

    public final HttpResponse handle(HttpRequest req, HttpResponse resp) {
        try {
            return this.handleResponse(req, resp);
        }
        catch (RuntimeException e) {
            this.propagateExceptionMessageSafe(e);
            throw e;
        }
    }

    protected abstract HttpResponse handleResponse(HttpRequest var1, HttpResponse var2);

    @ConstructorProperties(value={"tigerProxy", "tigerRoute"})
    @Generated
    public AbstractTigerRouteCallback(TigerProxy tigerProxy, TigerRoute tigerRoute) {
        this.tigerProxy = tigerProxy;
        this.tigerRoute = tigerRoute;
    }

    @Generated
    public TigerProxy getTigerProxy() {
        return this.tigerProxy;
    }

    @Generated
    public TigerRoute getTigerRoute() {
        return this.tigerRoute;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractTigerRouteCallback)) {
            return false;
        }
        AbstractTigerRouteCallback other = (AbstractTigerRouteCallback)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TigerProxy this$tigerProxy = this.getTigerProxy();
        TigerProxy other$tigerProxy = other.getTigerProxy();
        if (this$tigerProxy == null ? other$tigerProxy != null : !((Object)this$tigerProxy).equals(other$tigerProxy)) {
            return false;
        }
        TigerRoute this$tigerRoute = this.getTigerRoute();
        TigerRoute other$tigerRoute = other.getTigerRoute();
        return !(this$tigerRoute == null ? other$tigerRoute != null : !this$tigerRoute.equals(other$tigerRoute));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractTigerRouteCallback;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TigerProxy $tigerProxy = this.getTigerProxy();
        result = result * 59 + ($tigerProxy == null ? 43 : ((Object)$tigerProxy).hashCode());
        TigerRoute $tigerRoute = this.getTigerRoute();
        result = result * 59 + ($tigerRoute == null ? 43 : $tigerRoute.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractTigerRouteCallback(tigerProxy=" + this.getTigerProxy() + ", tigerRoute=" + this.getTigerRoute() + ")";
    }
}

