/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.test.tiger.common.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.proxy.AbstractTigerRouteCallback;
import de.gematik.test.tiger.proxy.TigerProxy;
import java.net.URI;
import lombok.Generated;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReverseProxyCallback
extends AbstractTigerRouteCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReverseProxyCallback.class);
    private final URI targetUri;
    private final int port;

    public ReverseProxyCallback(TigerProxy tigerProxy, TigerRoute route) {
        super(tigerProxy, route);
        this.targetUri = new URI(route.getTo());
        this.port = this.targetUri.getPort() < 0 ? (route.getTo().startsWith("https://") ? 443 : 80) : this.targetUri.getPort();
    }

    public HttpRequest handle(HttpRequest httpRequest) {
        this.applyModifications(httpRequest);
        HttpRequest request = httpRequest.withSocketAddress(Boolean.valueOf(this.getTigerRoute().getTo().startsWith("https://")), this.targetUri.getHost(), Integer.valueOf(this.port)).withSecure(Boolean.valueOf(this.getTigerRoute().getTo().startsWith("https://"))).removeHeader("Host").withPath(this.patchPath(httpRequest.getPath().getValue()));
        request.withHeader("Host", new String[]{this.targetUri.getHost() + ":" + this.port});
        if (this.getTigerRoute().getBasicAuth() != null) {
            request.withHeader("Authorization", new String[]{this.getTigerRoute().getBasicAuth().toAuthorizationHeaderValue()});
        }
        return request;
    }

    private String patchPath(String requestPath) {
        String patchedUrl = requestPath.replaceFirst(this.targetUri.toString(), "");
        if (!this.getTigerRoute().getFrom().equals("/")) {
            patchedUrl = patchedUrl.substring(this.getTigerRoute().getFrom().length());
        }
        if (patchedUrl.startsWith("/")) {
            return this.targetUri.getPath() + patchedUrl;
        }
        return this.targetUri.getPath() + "/" + patchedUrl;
    }

    public HttpResponse handle(HttpRequest httpRequest, HttpResponse httpResponse) {
        this.applyModifications(httpResponse);
        if (!this.getTigerRoute().isDisableRbelLogging()) {
            try {
                this.getTigerProxy().triggerListener(this.getTigerProxy().getMockServerToRbelConverter().convertRequest(httpRequest, this.getTigerRoute().getTo()));
                this.getTigerProxy().triggerListener(this.getTigerProxy().getMockServerToRbelConverter().convertResponse(httpResponse, this.getTigerRoute().getTo()));
            }
            catch (Exception e) {
                log.error("RBel FAILED!", (Throwable)e);
            }
        }
        return httpResponse;
    }
}

