/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.maven.usecases;

import de.gematik.test.tiger.maven.adapter.mojos.GenerateDriverProperties;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;

public class DriverGenerator {
    public static final String COUNTER_REPLACEMENT_TOKEN = "${ctr}";
    private GenerateDriverProperties props;
    private final Log log;

    public DriverGenerator(GenerateDriverProperties props, Log log) {
        this.props = props;
        this.log = log;
    }

    private String toCommaseparatedQuotedList(List<String> glues) {
        return Stream.concat(Stream.of("de.gematik.test.tiger.glue"), glues.stream()).distinct().map(this::withQuotes).collect(Collectors.joining(", "));
    }

    private String withQuotes(String it) {
        return "\"" + it + "\"";
    }

    public void generateDriverForFeatureFiles(List<String> files) throws IOException {
        this.createTargetFolderIfNotExists();
        int ctr = 1;
        for (String featureFile : files) {
            this.createTestDriverSourceFile(ctr++, featureFile);
        }
    }

    private void createTargetFolderIfNotExists() throws IOException {
        if (this.props.getOutputFolder().toFile().exists()) {
            FileUtils.deleteDirectory((File)this.props.getOutputFolder().toFile());
        }
        Files.createDirectories(this.props.getOutputFolderToPackage(), new FileAttribute[0]);
    }

    private void createTestDriverSourceFile(int ctr, String featurePath) throws IOException {
        String currentDriverClassName = this.props.getDriverClassName().replace(COUNTER_REPLACEMENT_TOKEN, String.format("%03d", ctr));
        String driverSourceCode = this.getDriverClassSourceCodeAsString(ctr, featurePath, currentDriverClassName);
        String filePath = this.writeToDriverSourceFile(currentDriverClassName, driverSourceCode);
        this.log.info((CharSequence)(" Feature '" + featurePath + "'"));
        this.log.info((CharSequence)(" Java => '" + filePath + "'"));
    }

    private String getDriverClassSourceCodeAsString(int ctr, String featurePath, String currentDriverClassName) throws IOException {
        String packageLine = StringUtils.isBlank((CharSequence)this.props.getDriverPackage()) ? "" : "package " + this.props.getDriverPackage() + ";\n";
        return this.getTemplate().replace(COUNTER_REPLACEMENT_TOKEN, String.valueOf(ctr)).replace("${package}", packageLine).replace("${driverClassName}", currentDriverClassName).replace("${feature}", featurePath.replace("\\", "/")).replace("${glues}", this.toCommaseparatedQuotedList(this.props.getGlues())).replace("${gluesCsv}", this.props.getGluesCsv()).replace("${tags}", this.props.getCucumberFilterTags());
    }

    private String writeToDriverSourceFile(String currentDriverClassName, String driverSourceCode) throws IOException {
        Path sourceFile = this.props.getOutputFolderToPackage().resolve(currentDriverClassName + ".java");
        Files.write(sourceFile, driverSourceCode.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        return sourceFile.toFile().getAbsolutePath();
    }

    private String getTemplate() throws IOException {
        if (this.props.getTemplateFile() == null) {
            String driverTemplateResource = this.props.isJunit5Driver() ? "/driver5ClassTemplate.jtmpl" : "/driver4ClassTemplate.jtmpl";
            try (InputStream is = this.getClass().getResourceAsStream(driverTemplateResource);){
                if (is == null) {
                    throw new FileNotFoundException("Unable to find template file resource '/driverClassTemplate.jtmpl' in jar!");
                }
                this.log.debug((CharSequence)"Using template file from jar ressource");
                String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                return string;
            }
        }
        this.log.info((CharSequence)("Using template file '" + this.props.getTemplateFile() + "'"));
        return Files.readString(this.props.getTemplateFile(), StandardCharsets.UTF_8);
    }
}

