/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.maven.adapter.mojos;

import de.gematik.test.tiger.common.web.TigerBrowserUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import lombok.Generated;
import net.serenitybdd.reports.email.SinglePageHtmlReporter;
import net.thucydides.core.reports.html.HtmlAggregateStoryReporter;
import net.thucydides.model.reports.ResultChecker;
import net.thucydides.model.reports.TestOutcomes;
import net.thucydides.model.requirements.FileSystemRequirements;
import net.thucydides.model.requirements.Requirements;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-serenity-reports", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class TigerSerenityReportMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/site/serenity", required=true)
    public File reportDirectory;
    @Parameter(defaultValue="src/test/resources/features", required=true)
    public String requirementsBaseDir;
    @Parameter(defaultValue="false", required=false)
    public boolean openSerenityReportInBrowser;

    public void execute() throws MojoExecutionException {
        try {
            this.generateHtmlStoryReports();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error generating serenity reports", e);
        }
    }

    private void generateHtmlStoryReports() throws IOException {
        if (!this.reportDirectory.exists()) {
            this.getLog().warn((CharSequence)("Report directory does not exist yet: " + this.reportDirectory));
            return;
        }
        HtmlAggregateStoryReporter reporter = new HtmlAggregateStoryReporter("default", (Requirements)new FileSystemRequirements(this.requirementsBaseDir));
        reporter.setSourceDirectory(this.reportDirectory);
        reporter.setOutputDirectory(this.reportDirectory);
        reporter.setGenerateTestOutcomeReports();
        TestOutcomes outcomes = reporter.generateReportsForTestResultsFrom(this.reportDirectory);
        new ResultChecker(this.reportDirectory).checkTestResults(outcomes);
        SinglePageHtmlReporter singlePageReporter = new SinglePageHtmlReporter();
        singlePageReporter.setSourceDirectory(this.reportDirectory.toPath());
        singlePageReporter.setOutputDirectory(this.reportDirectory.toPath());
        Path generatedReport = singlePageReporter.generateReport();
        if (this.openSerenityReportInBrowser) {
            TigerBrowserUtil.openUrlInBrowser((String)(this.reportDirectory.toPath() + "\\index.html"), (String)"browser for serenity report");
        }
        this.getLog().info((CharSequence)("  - " + singlePageReporter.getDescription() + ": " + generatedReport.toUri()));
    }

    @Generated
    public TigerSerenityReportMojo() {
    }

    @Generated
    public File getReportDirectory() {
        return this.reportDirectory;
    }

    @Generated
    public String getRequirementsBaseDir() {
        return this.requirementsBaseDir;
    }

    @Generated
    public boolean isOpenSerenityReportInBrowser() {
        return this.openSerenityReportInBrowser;
    }

    @Generated
    public void setReportDirectory(File reportDirectory) {
        this.reportDirectory = reportDirectory;
    }

    @Generated
    public void setRequirementsBaseDir(String requirementsBaseDir) {
        this.requirementsBaseDir = requirementsBaseDir;
    }

    @Generated
    public void setOpenSerenityReportInBrowser(boolean openSerenityReportInBrowser) {
        this.openSerenityReportInBrowser = openSerenityReportInBrowser;
    }

    @Generated
    public String toString() {
        return "TigerSerenityReportMojo(reportDirectory=" + this.getReportDirectory() + ", requirementsBaseDir=" + this.getRequirementsBaseDir() + ", openSerenityReportInBrowser=" + this.isOpenSerenityReportInBrowser() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerSerenityReportMojo)) {
            return false;
        }
        TigerSerenityReportMojo other = (TigerSerenityReportMojo)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isOpenSerenityReportInBrowser() != other.isOpenSerenityReportInBrowser()) {
            return false;
        }
        File this$reportDirectory = this.getReportDirectory();
        File other$reportDirectory = other.getReportDirectory();
        if (this$reportDirectory == null ? other$reportDirectory != null : !((Object)this$reportDirectory).equals(other$reportDirectory)) {
            return false;
        }
        String this$requirementsBaseDir = this.getRequirementsBaseDir();
        String other$requirementsBaseDir = other.getRequirementsBaseDir();
        return !(this$requirementsBaseDir == null ? other$requirementsBaseDir != null : !this$requirementsBaseDir.equals(other$requirementsBaseDir));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerSerenityReportMojo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isOpenSerenityReportInBrowser() ? 79 : 97);
        File $reportDirectory = this.getReportDirectory();
        result = result * 59 + ($reportDirectory == null ? 43 : ((Object)$reportDirectory).hashCode());
        String $requirementsBaseDir = this.getRequirementsBaseDir();
        result = result * 59 + ($requirementsBaseDir == null ? 43 : $requirementsBaseDir.hashCode());
        return result;
    }
}

