/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.maven.adapter.mojos;

import de.gematik.test.tiger.lib.TigerDirector;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;

@Mojo(name="setup-testenv", defaultPhase=LifecyclePhase.INITIALIZE)
public class TestEnvironmentMojo
extends AbstractMojo {
    @Parameter
    private boolean skip = false;
    @Parameter(defaultValue="86400")
    private long autoShutdownAfterSeconds = Duration.ofDays(1L).getSeconds();
    private boolean isRunning = false;

    public void execute() {
        block4: {
            if (this.skip) {
                this.getLog().info((CharSequence)"Skipping");
                return;
            }
            this.isRunning = true;
            TigerDirector.startStandaloneTestEnvironment();
            this.getLog().info((CharSequence)"Tiger standalone test environment is setup!");
            try {
                Awaitility.await().atMost(this.autoShutdownAfterSeconds, TimeUnit.SECONDS).pollInterval(200L, TimeUnit.MILLISECONDS).until(() -> !this.isRunning() || TigerDirector.getTigerTestEnvMgr() == null || TigerDirector.getTigerTestEnvMgr().isShutDown());
                if (TigerDirector.getTigerTestEnvMgr() != null) {
                    TigerDirector.getTigerTestEnvMgr().shutDown();
                }
            }
            catch (ConditionTimeoutException cte) {
                this.getLog().info((CharSequence)"Tiger Testenvironment TIMEOUT reached, shutting down...");
                if (TigerDirector.getTigerTestEnvMgr() == null) break block4;
                TigerDirector.getTigerTestEnvMgr().shutDown();
            }
        }
        this.getLog().info((CharSequence)"Tiger standalone test environment is shut down!");
        this.isRunning = false;
    }

    void abort() {
        this.isRunning = false;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestEnvironmentMojo)) {
            return false;
        }
        TestEnvironmentMojo other = (TestEnvironmentMojo)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isSkip() != other.isSkip()) {
            return false;
        }
        if (this.getAutoShutdownAfterSeconds() != other.getAutoShutdownAfterSeconds()) {
            return false;
        }
        return this.isRunning() == other.isRunning();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TestEnvironmentMojo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSkip() ? 79 : 97);
        long $autoShutdownAfterSeconds = this.getAutoShutdownAfterSeconds();
        result = result * 59 + (int)($autoShutdownAfterSeconds >>> 32 ^ $autoShutdownAfterSeconds);
        result = result * 59 + (this.isRunning() ? 79 : 97);
        return result;
    }

    @Generated
    public boolean isSkip() {
        return this.skip;
    }

    @Generated
    public long getAutoShutdownAfterSeconds() {
        return this.autoShutdownAfterSeconds;
    }

    @Generated
    public boolean isRunning() {
        return this.isRunning;
    }

    @Generated
    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    @Generated
    public void setAutoShutdownAfterSeconds(long autoShutdownAfterSeconds) {
        this.autoShutdownAfterSeconds = autoShutdownAfterSeconds;
    }

    @Generated
    public void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    @Generated
    public String toString() {
        return "TestEnvironmentMojo(skip=" + this.isSkip() + ", autoShutdownAfterSeconds=" + this.getAutoShutdownAfterSeconds() + ", isRunning=" + this.isRunning() + ")";
    }
}

