/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.maven.adapter.mojos;

import com.google.code.maven_replacer_plugin.include.FileSelector;
import de.gematik.test.tiger.maven.adapter.mojos.GenerateDriverProperties;
import de.gematik.test.tiger.maven.usecases.DriverGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-drivers", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES)
public class GenerateDriverMojo
extends AbstractMojo {
    @Parameter
    private boolean skip = false;
    @Parameter(alias="basedir", defaultValue="${basedir}/src/test/resources/features")
    private String featuresDir;
    @Parameter(required=true, defaultValue="**/*.feature")
    private List<String> includes = new ArrayList<String>();
    @Parameter
    private List<String> excludes = new ArrayList<String>();
    @Parameter(defaultValue="${project.groupId}")
    private List<String> glues = new ArrayList<String>();
    @Parameter(defaultValue="de.gematik.test.tiger.serenity.drivers")
    private String driverPackage;
    @Parameter(defaultValue="Driver${ctr}IT")
    private String driverClassName;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private String targetFolder;
    @Parameter
    private File templateFile;
    @Parameter
    private boolean junit5Driver = false;
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping");
            return;
        }
        this.checkParams();
        try {
            Path outputFolder = Paths.get(this.targetFolder, "generated-test-sources", "tigerbdd");
            outputFolder = StringUtils.isBlank((CharSequence)this.driverPackage) ? outputFolder : outputFolder.resolve(this.driverPackage.replace(".", File.separator));
            GenerateDriverProperties props = GenerateDriverProperties.builder().glues(this.glues).gluesCsv(String.join((CharSequence)",", this.glues)).driverPackage(this.driverPackage).driverClassName(this.driverClassName).templateFile(this.templateFile == null ? null : this.templateFile.toPath()).junit5Driver(this.junit5Driver).outputFolder(outputFolder).featuresRootFolder(this.featuresDir).build();
            props.log(this.getLog());
            List featureFiles = new FileSelector().listIncludes(this.featuresDir, this.includes, this.excludes);
            if (featureFiles.isEmpty()) {
                throw new MojoExecutionException("No matching feature file found! Please check your include and exclude values");
            }
            this.getLog().info((CharSequence)("Creating test drivers for " + featureFiles.size() + " feature files:"));
            new DriverGenerator(props, this.getLog()).generateDriverForFeatureFiles(featureFiles.stream().map(this::addBasedirPrefix).toList());
            this.project.addTestCompileSourceRoot(Paths.get(this.targetFolder, "generated-test-sources", "tigerbdd").toAbsolutePath().toString());
        }
        catch (IOException e) {
            throw new MojoExecutionException("File read/write failure!", (Exception)e);
        }
    }

    private void checkParams() throws MojoExecutionException {
        if (this.includes.isEmpty()) {
            throw new MojoExecutionException("Includes are mandatory!");
        }
        if (!this.driverClassName.contains("${ctr}")) {
            throw new MojoExecutionException("Driver class name does not contain ${ctr}! So only one driver java file will be generated and always overwritten! Make sure to include the '${ctr}' token to create driver files for each feature file.");
        }
    }

    private String addBasedirPrefix(String file) {
        if (StringUtils.isBlank((CharSequence)this.featuresDir)) {
            return file;
        }
        return this.featuresDir + "/" + file;
    }

    @Generated
    public boolean isSkip() {
        return this.skip;
    }

    @Generated
    public String getFeaturesDir() {
        return this.featuresDir;
    }

    @Generated
    public List<String> getIncludes() {
        return this.includes;
    }

    @Generated
    public List<String> getExcludes() {
        return this.excludes;
    }

    @Generated
    public List<String> getGlues() {
        return this.glues;
    }

    @Generated
    public String getDriverPackage() {
        return this.driverPackage;
    }

    @Generated
    public String getDriverClassName() {
        return this.driverClassName;
    }

    @Generated
    public String getTargetFolder() {
        return this.targetFolder;
    }

    @Generated
    public File getTemplateFile() {
        return this.templateFile;
    }

    @Generated
    public boolean isJunit5Driver() {
        return this.junit5Driver;
    }

    @Generated
    public MavenProject getProject() {
        return this.project;
    }

    @Generated
    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    @Generated
    public void setFeaturesDir(String featuresDir) {
        this.featuresDir = featuresDir;
    }

    @Generated
    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    @Generated
    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    @Generated
    public void setGlues(List<String> glues) {
        this.glues = glues;
    }

    @Generated
    public void setDriverPackage(String driverPackage) {
        this.driverPackage = driverPackage;
    }

    @Generated
    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    @Generated
    public void setTargetFolder(String targetFolder) {
        this.targetFolder = targetFolder;
    }

    @Generated
    public void setTemplateFile(File templateFile) {
        this.templateFile = templateFile;
    }

    @Generated
    public void setJunit5Driver(boolean junit5Driver) {
        this.junit5Driver = junit5Driver;
    }

    @Generated
    public void setProject(MavenProject project) {
        this.project = project;
    }

    @Generated
    public String toString() {
        return "GenerateDriverMojo(skip=" + this.isSkip() + ", featuresDir=" + this.getFeaturesDir() + ", includes=" + this.getIncludes() + ", excludes=" + this.getExcludes() + ", glues=" + this.getGlues() + ", driverPackage=" + this.getDriverPackage() + ", driverClassName=" + this.getDriverClassName() + ", targetFolder=" + this.getTargetFolder() + ", templateFile=" + this.getTemplateFile() + ", junit5Driver=" + this.isJunit5Driver() + ", project=" + this.getProject() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenerateDriverMojo)) {
            return false;
        }
        GenerateDriverMojo other = (GenerateDriverMojo)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isSkip() != other.isSkip()) {
            return false;
        }
        if (this.isJunit5Driver() != other.isJunit5Driver()) {
            return false;
        }
        String this$featuresDir = this.getFeaturesDir();
        String other$featuresDir = other.getFeaturesDir();
        if (this$featuresDir == null ? other$featuresDir != null : !this$featuresDir.equals(other$featuresDir)) {
            return false;
        }
        List<String> this$includes = this.getIncludes();
        List<String> other$includes = other.getIncludes();
        if (this$includes == null ? other$includes != null : !((Object)this$includes).equals(other$includes)) {
            return false;
        }
        List<String> this$excludes = this.getExcludes();
        List<String> other$excludes = other.getExcludes();
        if (this$excludes == null ? other$excludes != null : !((Object)this$excludes).equals(other$excludes)) {
            return false;
        }
        List<String> this$glues = this.getGlues();
        List<String> other$glues = other.getGlues();
        if (this$glues == null ? other$glues != null : !((Object)this$glues).equals(other$glues)) {
            return false;
        }
        String this$driverPackage = this.getDriverPackage();
        String other$driverPackage = other.getDriverPackage();
        if (this$driverPackage == null ? other$driverPackage != null : !this$driverPackage.equals(other$driverPackage)) {
            return false;
        }
        String this$driverClassName = this.getDriverClassName();
        String other$driverClassName = other.getDriverClassName();
        if (this$driverClassName == null ? other$driverClassName != null : !this$driverClassName.equals(other$driverClassName)) {
            return false;
        }
        String this$targetFolder = this.getTargetFolder();
        String other$targetFolder = other.getTargetFolder();
        if (this$targetFolder == null ? other$targetFolder != null : !this$targetFolder.equals(other$targetFolder)) {
            return false;
        }
        File this$templateFile = this.getTemplateFile();
        File other$templateFile = other.getTemplateFile();
        if (this$templateFile == null ? other$templateFile != null : !((Object)this$templateFile).equals(other$templateFile)) {
            return false;
        }
        MavenProject this$project = this.getProject();
        MavenProject other$project = other.getProject();
        return !(this$project == null ? other$project != null : !this$project.equals(other$project));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GenerateDriverMojo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isSkip() ? 79 : 97);
        result = result * 59 + (this.isJunit5Driver() ? 79 : 97);
        String $featuresDir = this.getFeaturesDir();
        result = result * 59 + ($featuresDir == null ? 43 : $featuresDir.hashCode());
        List<String> $includes = this.getIncludes();
        result = result * 59 + ($includes == null ? 43 : ((Object)$includes).hashCode());
        List<String> $excludes = this.getExcludes();
        result = result * 59 + ($excludes == null ? 43 : ((Object)$excludes).hashCode());
        List<String> $glues = this.getGlues();
        result = result * 59 + ($glues == null ? 43 : ((Object)$glues).hashCode());
        String $driverPackage = this.getDriverPackage();
        result = result * 59 + ($driverPackage == null ? 43 : $driverPackage.hashCode());
        String $driverClassName = this.getDriverClassName();
        result = result * 59 + ($driverClassName == null ? 43 : $driverClassName.hashCode());
        String $targetFolder = this.getTargetFolder();
        result = result * 59 + ($targetFolder == null ? 43 : $targetFolder.hashCode());
        File $templateFile = this.getTemplateFile();
        result = result * 59 + ($templateFile == null ? 43 : ((Object)$templateFile).hashCode());
        MavenProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        return result;
    }
}

