/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.parent.tasks;

import de.gematik.parent.tasks.AbstractGematikTask;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class VersionSet
extends AbstractGematikTask {
    private static final String VERSION_TXT = "version.txt";
    private static final String INIT_VERSION = "1.0.0-SNAPSHOT";
    String versionToSet = "1.0.0-SNAPSHOT";

    public VersionSet() {
        this.setGroup("Gematik");
        this.setDescription("Load the project version from version.txt file. If this file not exists would the file created with initial version '1.0.0-SNAPSHOT' or with the Version from build.gradle at project root directory.");
    }

    @Option(option="value", description="Versionupdate in version.txt")
    void setVersion(String versionToSet) {
        if (this.checkVersion(versionToSet)) {
            this.versionToSet = versionToSet;
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(VERSION_TXT));){
                bw.write(versionToSet);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not change or create version.txt  file!", e);
            }
            this.removeVersionFromGradleFile();
        } else {
            this.errorWrongVersionFormat(versionToSet);
        }
    }

    @TaskAction
    public void versionSet() {
        this.setVersionForProject();
        this.printGematikLogo();
        String versionString = "  VERSION  " + this.getProject().getVersion() + "  ";
        String groupString = "  GROUP    " + this.getProject().getGroup() + "  ";
        String artefactString = "  NAME     " + this.getProject().getRootProject().getName() + " ";
        String versionline = this.getLineForString(versionString);
        String groupline = this.getLineForString(groupString);
        String artefactline = this.getLineForString(artefactString);
        this.getLogger().quiet("**********************************************************************************");
        this.getLogger().quiet(groupline);
        this.getLogger().quiet(artefactline);
        this.getLogger().quiet(versionline);
        this.getLogger().quiet("**********************************************************************************");
    }

    private void setVersionForProject() {
        File versionFile = new File(VERSION_TXT);
        if (!versionFile.exists()) {
            this.getProject().getLogger().warn("File version.txt not found! Create new file.");
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(versionFile));){
                if (this.getProject().getVersion() != null && this.checkVersion(this.getProject().getVersion().toString().trim())) {
                    bw.write(this.getProject().getVersion().toString().trim());
                    this.removeVersionFromGradleFile();
                } else {
                    bw.write(this.versionToSet);
                    this.getProject().getLogger().error("The Version number '" + this.getProject().getVersion() + "' in build.gradle could not used because it don't match rulesVersion rules: \n{major}.{minor}.{patch}-{buildnummer} \n{major}.{minor}.{patch}-SNAPSHOT\n{major}.{minor}.{patch}.{gematikpatch}-{buildnummer}\n\nThe initial version number " + this.versionToSet + " for version.txt would used!");
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error by file version.txtcreation! Please create file version.txt manually and add the Version number as content.", e);
            }
        }
        try (BufferedReader br = new BufferedReader(new FileReader(versionFile));){
            String version = br.readLine().trim();
            if (this.checkVersion(version)) {
                this.getProject().setVersion((Object)version);
            } else {
                this.errorWrongVersionFormat(version);
            }
        }
        catch (Exception e) {
            this.getProject().getLogger().error("File version.txt not found or nit readable!", (Throwable)e);
        }
    }

    private void removeVersionFromGradleFile() {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(this.getProject().getBuildFile()));){
            String readLine = null;
            while ((readLine = br.readLine()) != null) {
                if (readLine.trim().startsWith("version") && readLine.trim().contains(this.getProject().getVersion().toString().trim())) continue;
                lines.add(readLine);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error by remove version number from build.gradle file!", e);
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.getProject().getBuildFile()));){
            boolean first = true;
            for (String line : lines) {
                if (!first) {
                    bw.newLine();
                }
                first = false;
                bw.write(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error by remove version number from build.gradle file!", e);
        }
    }

    private void errorWrongVersionFormat(String version) {
        throw new RuntimeException("The Version number '" + version + " could not used because it don't match rulesVersion rules: \n{major}.{minor}.{patch}-{buildnummer} \n{major}.{minor}.{patch}-SNAPSHOT\n{major}.{minor}.{patch}.{gematikpatch}-{buildnummer}");
    }

    private boolean checkVersion(String version) {
        return version.length() > 0 && (version.split("\\.").length == 3 || version.split("\\.").length == 4);
    }
}

