/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.parent;

import de.gematik.parent.tasks.Deploy;
import de.gematik.parent.tasks.VersionSet;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;

public class GematikParentPlugin
implements Plugin<Project> {
    private static final String CREATE_PUBLISH_TARGET = "createPublishTarget";

    public void apply(Project project) {
        boolean foundOrgSonarsourceScannerGradle;
        boolean foundOwasp;
        if (!(project.getPlugins().hasPlugin("com.android.application") || project.getPlugins().hasPlugin("com.android.library") || project.getPlugins().hasPlugin("java-library") || project.getPlugins().hasPlugin("com.android.feature") || project.getPlugins().hasPlugin("com.android.instantapp"))) {
            project.getPlugins().apply(JavaPlugin.class);
        }
        project.getPlugins().apply(MavenPublishPlugin.class);
        boolean bl = foundOwasp = !project.getBuildscript().getConfigurations().getByName("classpath").filter(a -> a.toString().contains("dependency-check")).isEmpty();
        if (foundOwasp && !project.getPlugins().hasPlugin("org.owasp.dependencycheck")) {
            System.out.println("Add 'org.owasp.dependencycheck' Plugin");
            project.getPlugins().apply("org.owasp.dependencycheck");
        }
        if (!project.getPlugins().hasPlugin("jacoco-android") && !project.getPlugins().hasPlugin("jacoco")) {
            project.getPlugins().apply("jacoco");
        }
        boolean bl2 = foundOrgSonarsourceScannerGradle = !project.getBuildscript().getConfigurations().getByName("classpath").filter(a -> a.toString().contains("org.sonarsource.scanner.gradle")).isEmpty();
        if (!(!foundOrgSonarsourceScannerGradle || project.getPlugins().hasPlugin("org.sonarqube") || project.getPlugins().hasPlugin("sonarqube") || project.getRootProject().getPlugins().hasPlugin("org.sonarqube") || project.getRootProject().getPlugins().hasPlugin("sonarqube"))) {
            System.out.println("Add org.sonarqube Plugin");
            project.getPlugins().apply("org.sonarqube");
        }
        this.configurePublishingExtension(project);
        VersionSet versionSet = (VersionSet)project.getTasks().create("versionset", VersionSet.class);
        if (project.getTasks().findByName(CREATE_PUBLISH_TARGET) != null) {
            versionSet.dependsOn(new Object[]{CREATE_PUBLISH_TARGET});
        }
        project.getTasks().create("deploy", Deploy.class);
        this.setVersionForAllTasks(project, versionSet);
    }

    private void setVersionForAllTasks(Project project, VersionSet versionSet) {
        project.getTasks().all(t -> {
            if (!(t instanceof VersionSet) && !t.getName().equals(CREATE_PUBLISH_TARGET)) {
                t.dependsOn(new Object[]{versionSet});
            }
        });
    }

    private void configurePublishingExtension(Project project) {
        PublishingExtension publishingExtension = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
        Set entrySet = project.getComponents().getAsMap().entrySet();
        if (!entrySet.isEmpty()) {
            MavenPublication publication = (MavenPublication)publishingExtension.getPublications().create("mavenJava", MavenPublication.class);
            SoftwareComponent value = (SoftwareComponent)entrySet.iterator().next().getValue();
            publication.from(value);
        }
    }
}

