/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.prepare;

import de.gematik.combine.model.CombineItem;
import de.gematik.prepare.PrepareItemsConfig;
import de.gematik.prepare.PrepareItemsMojo;
import de.gematik.utils.Utils;
import io.cucumber.core.internal.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minidev.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;

public class Pooler {
    private static final String CONTAINING = "contains";
    private static final String NOT_CONTAINING = "notContaining";
    private static final String EXCLUDED = "excluded";
    private final Random random = new Random();
    private PrepareItemsConfig config;

    public List<CombineItem> pool() throws MojoExecutionException {
        Map<String, List<CombineItem>> filteredMap = Utils.getItemsToCombine(new File(this.config.getCombineItemsFile()), (Mojo)PrepareItemsMojo.getInstance(), false).stream().collect(Collectors.groupingBy(this::order));
        this.doChecks(filteredMap);
        if (this.config.getGroups().isEmpty() && this.config.getPoolSize() <= 0) {
            return this.getAllPossibleItems(filteredMap);
        }
        if (filteredMap.get(CONTAINING).size() == this.config.getPoolSize()) {
            return filteredMap.get(CONTAINING);
        }
        return this.fillUpList(filteredMap);
    }

    private List<CombineItem> fillUpList(Map<String, List<CombineItem>> filteredMap) {
        List<CombineItem> finalListOfItems = filteredMap.get(CONTAINING);
        List<CombineItem> leftOvers = filteredMap.get(NOT_CONTAINING);
        while (this.countGroups(finalListOfItems) < (long)this.config.getPoolSize() || finalListOfItems.size() < this.config.getPoolSize()) {
            CombineItem randomSelectedItem = leftOvers.get(this.random.nextInt(leftOvers.size()));
            if (randomSelectedItem.getGroups().isEmpty()) {
                finalListOfItems.add(randomSelectedItem);
                leftOvers.remove(randomSelectedItem);
                continue;
            }
            String randomSelectedGroup = (String)randomSelectedItem.getGroups().toArray()[this.random.nextInt(randomSelectedItem.getGroups().size())];
            List allItemsOfRandomSelectedGroup = leftOvers.stream().filter(i -> i.getGroups().contains(randomSelectedGroup)).collect(Collectors.toList());
            finalListOfItems.addAll(allItemsOfRandomSelectedGroup);
            leftOvers.removeAll(allItemsOfRandomSelectedGroup);
        }
        this.writeUsedGroupsToFile(finalListOfItems);
        return finalListOfItems;
    }

    private void writeUsedGroupsToFile(List<CombineItem> finalListOfItems) {
        Set usedGroups = finalListOfItems.stream().map(CombineItem::getGroups).flatMap(Collection::stream).collect(Collectors.toSet());
        List<String> excludedGroups = this.config.getExcludedGroups();
        List usedWithoutGroups = finalListOfItems.stream().filter(e -> e.getGroups().isEmpty()).collect(Collectors.toList());
        JSONObject result = new JSONObject();
        result.put((Object)"usedGroups", usedGroups);
        result.put((Object)"usedItemsWithoutGroup", usedWithoutGroups.stream().map(CombineItem::getValue).collect(Collectors.toList()));
        result.put((Object)"excludedGroups", excludedGroups);
        FileUtils.writeStringToFile((File)new File(PrepareItemsMojo.GENERATED_COMBINE_ITEMS_DIR + File.separator + "usedGroups.json"), (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)result), (Charset)StandardCharsets.UTF_8);
    }

    private List<CombineItem> getAllPossibleItems(Map<String, List<CombineItem>> filteredMap) {
        return filteredMap.entrySet().stream().filter(e -> ((String)e.getKey()).equals(CONTAINING) || ((String)e.getKey()).equals(NOT_CONTAINING)).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private String order(CombineItem combineItem) {
        for (String itemGroup : combineItem.getGroups()) {
            if (this.config.getExcludedGroups().contains(itemGroup)) {
                return EXCLUDED;
            }
            if (!this.config.getGroups().contains(itemGroup)) continue;
            return CONTAINING;
        }
        return NOT_CONTAINING;
    }

    private void doChecks(Map<String, List<CombineItem>> filteredMap) throws MojoExecutionException {
        if (this.config.getGroups().size() > this.config.getPoolSize() && this.config.getPoolSize() > 0) {
            throw new MojoExecutionException("The given amount of groups is higher than the requested poolSize");
        }
        ArrayList<CombineItem> allValidItems = new ArrayList<CombineItem>();
        filteredMap.computeIfAbsent(CONTAINING, k -> new ArrayList());
        filteredMap.computeIfAbsent(NOT_CONTAINING, k -> new ArrayList());
        allValidItems.addAll((Collection)filteredMap.get(NOT_CONTAINING));
        allValidItems.addAll((Collection)filteredMap.get(CONTAINING));
        if (this.countGroups(allValidItems) < (long)this.config.getPoolSize()) {
            throw new MojoExecutionException("PoolSize to high! Could not find sufficient item-groups to fulfill request");
        }
    }

    private long countGroups(List<CombineItem> itemList) {
        long itemsWithoutGroup = itemList.stream().filter(i -> i.getGroups().isEmpty()).count();
        long sumGroupsFromItems = itemList.stream().map(CombineItem::getGroups).flatMap(Collection::stream).collect(Collectors.toSet()).size();
        return sumGroupsFromItems + itemsWithoutGroup;
    }

    @Generated
    public Pooler(PrepareItemsConfig config) {
        this.config = config;
    }

    @Generated
    public Pooler() {
    }

    @Generated
    public void setConfig(PrepareItemsConfig config) {
        this.config = config;
    }
}

