/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.util;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public enum CompareOperator {
    EQ("==", List.of(Integer.valueOf(0))),
    NE("!=", List.of(Integer.valueOf(-1), Integer.valueOf(1))),
    LE("<=", List.of(Integer.valueOf(-1), Integer.valueOf(0))),
    LT("<", List.of(Integer.valueOf(-1))),
    GE(">=", List.of(Integer.valueOf(0), Integer.valueOf(1))),
    GT(">", List.of(Integer.valueOf(1)));

    public static final String OPERATOR_FORMAT = "--%s--";
    private final String literal;
    private final List<Integer> matchingResults;

    public static String getUsableOperators() {
        return Arrays.stream(CompareOperator.values()).map(o -> String.format("--%s-- / %s", o.name(), o.getLiteral())).collect(Collectors.joining(", "));
    }

    public boolean includesResultOf(Integer comparedToResult) {
        return this.matchingResults.contains(comparedToResult);
    }

    @Generated
    private CompareOperator(String literal, List<Integer> matchingResults) {
        this.literal = literal;
        this.matchingResults = matchingResults;
    }

    @Generated
    public String getLiteral() {
        return this.literal;
    }
}

