/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.tags.parser;

import de.gematik.combine.filter.table.MaxRowsFilter;
import de.gematik.combine.tags.ParsedTags;
import de.gematik.combine.tags.SingleTagParser;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.math.NumberUtils;

@Named(value="MaxRows")
@Singleton
public class MaxRowsTagParser
implements SingleTagParser {
    public static final String MAX_ROWS_TAG = "MaxRows";

    @Override
    public void parseTagAndRegister(String value, ParsedTags parsedTags) {
        if (NumberUtils.isDigits((String)value) && NumberUtils.isParsable((String)value)) {
            int maxRows = Integer.parseInt(value);
            parsedTags.addConfigModifier(config -> config.toBuilder().maxTableRows(maxRows).build());
        } else {
            parsedTags.addTableFilter(new MaxRowsFilter(value));
        }
    }
}

