/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.filter;

import de.gematik.combine.filter.table.TableFilter;
import de.gematik.combine.filter.table.cell.CellFilter;
import de.gematik.combine.filter.table.row.RowFilter;
import de.gematik.combine.filter.table.row.TableRowFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class Filters {
    private final List<TableFilter> tableFilters;
    private final List<TableRowFilter> tableRowFilters;
    private final Map<String, List<CellFilter>> cellFilters;

    public void addTableFilter(TableFilter tableFilter) {
        this.tableFilters.add(tableFilter);
    }

    public void addTableRowFilter(TableRowFilter tableRowFilter) {
        this.tableRowFilters.add(tableRowFilter);
    }

    public void addCellFilter(String header, CellFilter newCellFilter) {
        if (this.cellFilters.containsKey(header)) {
            List<CellFilter> cellFilter = this.cellFilters.get(header);
            cellFilter.add(newCellFilter);
        } else {
            this.cellFilters.put(header, new ArrayList<CellFilter>(List.of(newCellFilter)));
        }
    }

    public void addCellFilter(String header, List<CellFilter> newCellFilter) {
        newCellFilter.forEach(cellFilter -> this.addCellFilter(header, (CellFilter)cellFilter));
    }

    public List<TableFilter> getTableFilters() {
        return Collections.unmodifiableList(this.tableFilters);
    }

    public List<TableRowFilter> getTableRowFilters() {
        return Collections.unmodifiableList(this.tableRowFilters);
    }

    public Map<String, List<CellFilter>> getCellFilters() {
        return Collections.unmodifiableMap(this.cellFilters.entrySet().stream().map(e -> Map.entry((String)e.getKey(), Collections.unmodifiableList((List)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public RowFilter combineAllRowFilters() {
        return this.getTableRowFilters().stream().reduce(x -> true, RowFilter::and, RowFilter::and);
    }

    public Map<String, CellFilter> combineCellFilters() {
        return Collections.unmodifiableMap(this.cellFilters.entrySet().stream().map(e -> Map.entry((String)e.getKey(), ((List)e.getValue()).stream().reduce(x -> true, CellFilter::and))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    @Generated
    private static List<TableFilter> $default$tableFilters() {
        return new ArrayList<TableFilter>();
    }

    @Generated
    private static List<TableRowFilter> $default$tableRowFilters() {
        return new ArrayList<TableRowFilter>();
    }

    @Generated
    private static Map<String, List<CellFilter>> $default$cellFilters() {
        return new HashMap<String, List<CellFilter>>();
    }

    @Generated
    public static FiltersBuilder builder() {
        return new FiltersBuilder();
    }

    @Generated
    public Filters() {
        this.tableFilters = Filters.$default$tableFilters();
        this.tableRowFilters = Filters.$default$tableRowFilters();
        this.cellFilters = Filters.$default$cellFilters();
    }

    @Generated
    public Filters(List<TableFilter> tableFilters, List<TableRowFilter> tableRowFilters, Map<String, List<CellFilter>> cellFilters) {
        this.tableFilters = tableFilters;
        this.tableRowFilters = tableRowFilters;
        this.cellFilters = cellFilters;
    }

    @Generated
    public static class FiltersBuilder {
        @Generated
        private boolean tableFilters$set;
        @Generated
        private List<TableFilter> tableFilters$value;
        @Generated
        private boolean tableRowFilters$set;
        @Generated
        private List<TableRowFilter> tableRowFilters$value;
        @Generated
        private boolean cellFilters$set;
        @Generated
        private Map<String, List<CellFilter>> cellFilters$value;

        @Generated
        FiltersBuilder() {
        }

        @Generated
        public FiltersBuilder tableFilters(List<TableFilter> tableFilters) {
            this.tableFilters$value = tableFilters;
            this.tableFilters$set = true;
            return this;
        }

        @Generated
        public FiltersBuilder tableRowFilters(List<TableRowFilter> tableRowFilters) {
            this.tableRowFilters$value = tableRowFilters;
            this.tableRowFilters$set = true;
            return this;
        }

        @Generated
        public FiltersBuilder cellFilters(Map<String, List<CellFilter>> cellFilters) {
            this.cellFilters$value = cellFilters;
            this.cellFilters$set = true;
            return this;
        }

        @Generated
        public Filters build() {
            List<TableFilter> tableFilters$value = this.tableFilters$value;
            if (!this.tableFilters$set) {
                tableFilters$value = Filters.$default$tableFilters();
            }
            List<TableRowFilter> tableRowFilters$value = this.tableRowFilters$value;
            if (!this.tableRowFilters$set) {
                tableRowFilters$value = Filters.$default$tableRowFilters();
            }
            Map<String, List<CellFilter>> cellFilters$value = this.cellFilters$value;
            if (!this.cellFilters$set) {
                cellFilters$value = Filters.$default$cellFilters();
            }
            return new Filters(tableFilters$value, tableRowFilters$value, cellFilters$value);
        }

        @Generated
        public String toString() {
            return "Filters.FiltersBuilder(tableFilters$value=" + this.tableFilters$value + ", tableRowFilters$value=" + this.tableRowFilters$value + ", cellFilters$value=" + this.cellFilters$value + ")";
        }
    }
}

