/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.filter;

import de.gematik.combine.filter.table.DistinctColumnFilter;
import de.gematik.combine.filter.table.DoubleLineupFilter;
import de.gematik.combine.filter.table.MaxRowsFilter;
import de.gematik.combine.filter.table.MaxSameColumnPropertyFilter;
import de.gematik.combine.filter.table.ShuffleTableFilter;
import de.gematik.combine.filter.table.TableFilter;
import de.gematik.combine.filter.table.row.TableRowFilter;
import java.util.Arrays;
import java.util.Set;
import lombok.Generated;

public enum FilterOrder {
    ROW_ONLY(0, Set.of(TableRowFilter.class)),
    SHUFFLE(1, Set.of(ShuffleTableFilter.class)),
    MAX_SAME_VALUE_COLUMN_PROPERTY(10, Set.of(MaxSameColumnPropertyFilter.class)),
    DISTINCT_COLUMN(20, Set.of(DistinctColumnFilter.class)),
    DOUBLE_LINEUP(30, Set.of(DoubleLineupFilter.class)),
    MAX_ROWS(Integer.MAX_VALUE, Set.of(MaxRowsFilter.class));

    public final int orderKey;
    private final Set<Class<? extends TableFilter>> filters;

    public static FilterOrder getFilterOrderFor(TableFilter tableFilter) {
        return Arrays.stream(FilterOrder.values()).filter(fo -> fo.filters.contains(tableFilter.getClass()) || fo.filters.contains(tableFilter.getClass().getSuperclass())).findFirst().orElseThrow(() -> new IllegalArgumentException(tableFilter.getClass().getName() + " has no FilterOrder entry"));
    }

    @Generated
    public int getOrderKey() {
        return this.orderKey;
    }

    @Generated
    public Set<Class<? extends TableFilter>> getFilters() {
        return this.filters;
    }

    @Generated
    private FilterOrder(int orderKey, Set<Class<? extends TableFilter>> filters) {
        this.orderKey = orderKey;
        this.filters = filters;
    }
}

