/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.execution;

import com.google.common.collect.Lists;
import de.gematik.combine.CombineMojo;
import de.gematik.combine.filter.table.cell.CellFilter;
import de.gematik.combine.filter.table.row.RowFilter;
import de.gematik.combine.model.CombineItem;
import de.gematik.combine.model.TableCell;
import de.gematik.combine.tags.ConfiguredFilters;
import de.gematik.combine.util.CurrentScenario;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class TableGenerator {
    private static final int ONE_MILLION = 1000000;

    public List<List<TableCell>> generateTable(List<CombineItem> combineItems, ConfiguredFilters filters) {
        if (filters.getActualConfig().isMinimalTable()) {
            return this.generateMinimalTable(combineItems, filters);
        }
        return this.generateFullTable(combineItems, filters);
    }

    private List<List<TableCell>> generateFullTable(List<CombineItem> combineItems, ConfiguredFilters filters) {
        List<String> columns = filters.getColumns();
        List<List<TableCell>> preparedColumns = this.preFilteredColumns(combineItems, filters);
        CombineMojo.getPluginLog().debug((CharSequence)String.format("creating cartesianProduct table with %d columns", columns.size()));
        if (columns.size() > 5) {
            CombineMojo.getPluginLog().warn((CharSequence)String.format("creating cartesianProduct table with %d columns produces a huge amount of entries and can cause out of memory errors", columns.size()));
        }
        ArrayList<List<TableCell>> table = new ArrayList<List<TableCell>>(Lists.cartesianProduct(preparedColumns));
        CombineMojo.getPluginLog().debug((CharSequence)String.format("created table with %d columns and %d rows", columns.size(), table.size()));
        if (table.size() > 1000000) {
            CombineMojo.getPluginLog().warn((CharSequence)"Such a big table will need chunking and a considerable amount of time for filtering.\nPlease use '@Filter' tags with just one header reference to filter columns before applying the cartesian product and therefore reduce generated table size.");
        }
        return table;
    }

    private List<List<TableCell>> preFilteredColumns(List<CombineItem> combineItems, ConfiguredFilters filters) {
        List<String> headers = filters.getColumns();
        CombineMojo.getPluginLog().debug((CharSequence)("Applied cell filters: " + filters.getCellFilters()));
        Map<String, CellFilter> cellFilters = filters.combineCellFilters();
        ArrayList<List<TableCell>> preparedColumns = new ArrayList<List<TableCell>>();
        for (String header : headers) {
            List e = combineItems.stream().map(s -> new TableCell(header, (CombineItem)s)).filter(cellFilters.getOrDefault(header, x -> true)).collect(Collectors.toList());
            if (filters.getActualConfig().isShuffleCombinations()) {
                Collections.shuffle(e);
            }
            preparedColumns.add(e);
        }
        CombineMojo.getPluginLog().debug((CharSequence)String.format("prepared columns after applied cell filters: %s", preparedColumns));
        return preparedColumns;
    }

    private List<List<TableCell>> generateMinimalTable(List<CombineItem> combineItems, ConfiguredFilters filters) {
        List<String> columns = filters.getColumns();
        CombineMojo.getPluginLog().debug((CharSequence)String.format("creating minimal table with %d columns", columns.size()));
        List<List<TableCell>> preparedColumns = this.preFilteredColumns(combineItems, filters);
        boolean anyColumnEmpty = preparedColumns.stream().anyMatch(List::isEmpty);
        if (anyColumnEmpty) {
            CombineMojo.getPluginLog().debug((CharSequence)"could not generate any row for minimal table");
            return Collections.emptyList();
        }
        CombineMojo.getPluginLog().debug((CharSequence)("Applied row filter: " + filters.getTableRowFilters()));
        CombineMojo.getPluginLog().debug((CharSequence)("Applied configuration: " + filters.getActualConfig()));
        StateInfo stateInfo = new StateInfo(filters, preparedColumns);
        this.forEachUnusedValue(stateInfo, unusedValue -> this.findValidRow(stateInfo, (TableCell)unusedValue).ifPresent(stateInfo::addNewRow));
        if (stateInfo.getAllMissingValues().size() != 0) {
            stateInfo.getAllMissingValues().forEach(e -> CombineMojo.appendError(String.format("Building minimal table failed for scenario: \"%s\". No row could be build for -> value: %s%s", CurrentScenario.getCurrenScenarioName(), e.getValue(), Objects.nonNull(e.getUrl()) ? " url: " + e.getUrl() : ""), CombineMojo.ErrorType.MINIMAL_TABLE));
        }
        return stateInfo.getResult();
    }

    private void forEachUnusedValue(StateInfo stateInfo, Consumer<TableCell> unusedValueConsumer) {
        for (List<TableCell> preparedColumn : stateInfo.getPreparedColumns()) {
            for (TableCell tableCell : preparedColumn) {
                if (!stateInfo.getAllMissingValues().contains(tableCell.getCombineItem())) continue;
                Optional.of(tableCell).ifPresent(unusedValueConsumer);
            }
        }
    }

    private Optional<List<TableCell>> findValidRow(StateInfo stateInfo, TableCell firstValue) {
        List<String> columns = stateInfo.getFilters().getColumns();
        List<List<TableCell>> preparedColumns = stateInfo.getPreparedColumns();
        Optional<List<TableCell>> completeRow = this.forEachColumnExtendRow(firstValue, columns, preparedColumns, (row, possibleValues) -> this.addNewValueToRow(stateInfo, (List<TableCell>)row, (List<TableCell>)possibleValues));
        return completeRow.map(row -> this.sortRowForColumns(columns, (List<TableCell>)row));
    }

    private Optional<List<TableCell>> addNewValueToRow(StateInfo stateInfo, List<TableCell> row, List<TableCell> possibleValues) {
        List<TableCell> missingColumnValues = possibleValues.stream().filter(val -> stateInfo.getAllMissingValues().contains(val.getCombineItem())).collect(Collectors.toList());
        ArrayList<RowFilter> rowFilters = new ArrayList<RowFilter>(stateInfo.getFilters().getTableRowFilters());
        Optional<TableCell> newColValue = this.findNewRowValue(stateInfo, possibleValues, missingColumnValues, row, rowFilters);
        return newColValue.map(value -> {
            ArrayList<TableCell> extendedRow = new ArrayList<TableCell>(row);
            extendedRow.add((TableCell)value);
            return extendedRow;
        });
    }

    private Optional<List<TableCell>> forEachColumnExtendRow(TableCell firstValue, List<String> columns, List<List<TableCell>> preparedColumns, BiFunction<List<TableCell>, List<TableCell>, Optional<List<TableCell>>> rowExtender) {
        int startColumn = columns.indexOf(firstValue.getHeader());
        ArrayList<TableCell> tmpRow = new ArrayList<TableCell>(columns.size());
        tmpRow.add(firstValue);
        Optional<List<TableCell>> row = Optional.of(tmpRow);
        int currentColumn = (startColumn + 1) % columns.size();
        while (currentColumn != startColumn) {
            List<TableCell> possibleValues = preparedColumns.get(currentColumn);
            if ((row = rowExtender.apply(row.get(), possibleValues)).isEmpty()) {
                CombineMojo.getPluginLog().debug((CharSequence)("could not create a valid row for: " + firstValue));
                return row;
            }
            currentColumn = (currentColumn + 1) % columns.size();
        }
        return row;
    }

    private Optional<TableCell> findNewRowValue(StateInfo stateInfo, List<TableCell> preparedValues, List<TableCell> remainingValuesForThisColumn, List<TableCell> row, List<RowFilter> rowFilter) {
        return this.findNewValueNotContainedIn(stateInfo, remainingValuesForThisColumn, row, stateInfo.getAllUsedValues(), rowFilter).or(() -> this.findNewValueNotContainedIn(stateInfo, remainingValuesForThisColumn, row, Collections.emptySet(), rowFilter)).or(() -> this.findNewValueMatchingFilter(stateInfo, preparedValues, row, rowFilter));
    }

    private Optional<TableCell> findNewValueMatchingFilter(StateInfo stateInfo, List<TableCell> possibleValues, List<TableCell> row, List<RowFilter> rowFilters) {
        for (TableCell possibleValue : possibleValues) {
            ArrayList<TableCell> extendedRow = new ArrayList<TableCell>(row);
            extendedRow.add(possibleValue);
            if (!this.checkRowFilter(extendedRow, rowFilters, stateInfo.getFilters().getColumns())) continue;
            return Optional.of(possibleValue);
        }
        return Optional.empty();
    }

    private Optional<TableCell> findNewValueNotContainedIn(StateInfo stateInfo, List<TableCell> possibleValues, List<TableCell> usedRowValues, Set<CombineItem> allUsedValues, List<RowFilter> rowFilters) {
        List<String> allColumns = stateInfo.getFilters().getColumns();
        Set usedCombineItems = Stream.concat(allUsedValues.stream(), usedRowValues.stream().map(TableCell::getCombineItem)).collect(Collectors.toSet());
        for (TableCell possibleValue : possibleValues) {
            ArrayList<TableCell> possibleRow = new ArrayList<TableCell>(usedRowValues);
            possibleRow.add(possibleValue);
            if (usedCombineItems.contains(possibleValue.getCombineItem()) || !this.checkRowFilter(possibleRow, rowFilters, allColumns)) continue;
            return Optional.of(possibleValue);
        }
        return Optional.empty();
    }

    private boolean checkRowFilter(List<TableCell> row, List<RowFilter> rowFilters, List<String> allHeaders) {
        return rowFilters.stream().filter(rf -> this.isApplicable(row, (RowFilter)rf, allHeaders)).allMatch(rf -> rf.test(row));
    }

    private boolean isApplicable(List<TableCell> row, RowFilter rowFilter, List<String> allHeaders) {
        List<String> requiredColumns = rowFilter.getRequiredColumns(allHeaders);
        Set filledColumns = row.stream().map(TableCell::getHeader).collect(Collectors.toSet());
        return filledColumns.containsAll(requiredColumns);
    }

    private List<TableCell> sortRowForColumns(List<String> columns, List<TableCell> row) {
        row.sort(Comparator.comparingInt(a -> columns.indexOf(a.getHeader())));
        return row;
    }

    public static class StateInfo {
        private final ConfiguredFilters filters;
        private final List<List<TableCell>> preparedColumns;
        private final Set<CombineItem> allMissingValues;
        private final Set<CombineItem> allUsedValues = new TreeSet<CombineItem>();
        private final List<List<TableCell>> result = new ArrayList<List<TableCell>>();

        public StateInfo(ConfiguredFilters filters, List<List<TableCell>> preparedColumns) {
            this.filters = filters;
            this.preparedColumns = preparedColumns;
            this.allMissingValues = this.compute(preparedColumns);
        }

        private Set<CombineItem> compute(List<List<TableCell>> preparedColumns) {
            return preparedColumns.stream().flatMap(Collection::stream).map(TableCell::getCombineItem).collect(Collectors.toSet());
        }

        public void addNewRow(List<TableCell> row) {
            this.result.add(row);
            Set rowValues = row.stream().map(TableCell::getCombineItem).collect(Collectors.toSet());
            this.allUsedValues.addAll(rowValues);
            this.allMissingValues.removeAll(rowValues);
        }

        @Generated
        public ConfiguredFilters getFilters() {
            return this.filters;
        }

        @Generated
        public List<List<TableCell>> getPreparedColumns() {
            return this.preparedColumns;
        }

        @Generated
        public Set<CombineItem> getAllMissingValues() {
            return this.allMissingValues;
        }

        @Generated
        public Set<CombineItem> getAllUsedValues() {
            return this.allUsedValues;
        }

        @Generated
        public List<List<TableCell>> getResult() {
            return this.result;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StateInfo)) {
                return false;
            }
            StateInfo other = (StateInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ConfiguredFilters this$filters = this.getFilters();
            ConfiguredFilters other$filters = other.getFilters();
            if (this$filters == null ? other$filters != null : !this$filters.equals(other$filters)) {
                return false;
            }
            List<List<TableCell>> this$preparedColumns = this.getPreparedColumns();
            List<List<TableCell>> other$preparedColumns = other.getPreparedColumns();
            if (this$preparedColumns == null ? other$preparedColumns != null : !((Object)this$preparedColumns).equals(other$preparedColumns)) {
                return false;
            }
            Set<CombineItem> this$allMissingValues = this.getAllMissingValues();
            Set<CombineItem> other$allMissingValues = other.getAllMissingValues();
            if (this$allMissingValues == null ? other$allMissingValues != null : !((Object)this$allMissingValues).equals(other$allMissingValues)) {
                return false;
            }
            Set<CombineItem> this$allUsedValues = this.getAllUsedValues();
            Set<CombineItem> other$allUsedValues = other.getAllUsedValues();
            if (this$allUsedValues == null ? other$allUsedValues != null : !((Object)this$allUsedValues).equals(other$allUsedValues)) {
                return false;
            }
            List<List<TableCell>> this$result = this.getResult();
            List<List<TableCell>> other$result = other.getResult();
            return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StateInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ConfiguredFilters $filters = this.getFilters();
            result = result * 59 + ($filters == null ? 43 : $filters.hashCode());
            List<List<TableCell>> $preparedColumns = this.getPreparedColumns();
            result = result * 59 + ($preparedColumns == null ? 43 : ((Object)$preparedColumns).hashCode());
            Set<CombineItem> $allMissingValues = this.getAllMissingValues();
            result = result * 59 + ($allMissingValues == null ? 43 : ((Object)$allMissingValues).hashCode());
            Set<CombineItem> $allUsedValues = this.getAllUsedValues();
            result = result * 59 + ($allUsedValues == null ? 43 : ((Object)$allUsedValues).hashCode());
            List<List<TableCell>> $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TableGenerator.StateInfo(filters=" + this.getFilters() + ", preparedColumns=" + this.getPreparedColumns() + ", allMissingValues=" + this.getAllMissingValues() + ", allUsedValues=" + this.getAllUsedValues() + ", result=" + this.getResult() + ")";
        }
    }
}

