/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.wicket.model.transformation;

import de.flapdoodle.functions.Function;
import de.flapdoodle.functions.Function1;
import de.flapdoodle.functions.Function2;
import de.flapdoodle.functions.Function3;
import de.flapdoodle.wicket.model.transformation.Lazy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

abstract class Transformator<T>
extends LoadableDetachableModel<T> {
    private final IModel<?>[] _subModels;
    private final Function _function;

    protected Transformator(Function function, IModel<?> ... subModels) {
        this._subModels = subModels;
        this._function = function;
    }

    protected void onDetach() {
        for (IModel<?> m : this._subModels) {
            m.detach();
        }
    }

    public void setObject(T object) {
        throw new UnsupportedOperationException("Model " + ((Object)((Object)this)).getClass() + " with " + this._function + " does not support setObject(Object)");
    }

    private static <T> Lazy<T> lazy(IModel<T> model) {
        return new LazyModelAdapter<T>(model);
    }

    static final class LazyModelAdapter<T>
    implements Lazy<T> {
        private final IModel<T> _model;

        public LazyModelAdapter(IModel<T> model) {
            this._model = model;
        }

        @Override
        public T get() {
            return (T)this._model.getObject();
        }
    }

    static final class LazyModel3<T, M1, M2, M3>
    extends Transformator<T> {
        IModel<M1> _m1;
        IModel<M2> _m2;
        IModel<M3> _m3;
        Function3<T, Lazy<M1>, Lazy<M2>, Lazy<M3>> _function;

        public LazyModel3(IModel<M1> m1, IModel<M2> m2, IModel<M3> m3, Function3<T, Lazy<M1>, Lazy<M2>, Lazy<M3>> function) {
            super(function, m1, m2, m3);
            this._m1 = m1;
            this._m2 = m2;
            this._m3 = m3;
            this._function = function;
        }

        protected T load() {
            return this._function.apply(Transformator.lazy(this._m1), Transformator.lazy(this._m2), Transformator.lazy(this._m3));
        }
    }

    static final class LazyModel2<T, M1, M2>
    extends Transformator<T> {
        IModel<M1> _m1;
        IModel<M2> _m2;
        Function2<T, Lazy<M1>, Lazy<M2>> _function;

        public LazyModel2(IModel<M1> m1, IModel<M2> m2, Function2<T, Lazy<M1>, Lazy<M2>> function) {
            super(function, m1, m2);
            this._m1 = m1;
            this._m2 = m2;
            this._function = function;
        }

        protected T load() {
            return this._function.apply(Transformator.lazy(this._m1), Transformator.lazy(this._m2));
        }
    }

    static final class LazyModel1<T, M1>
    extends Transformator<T> {
        IModel<M1> _m1;
        Function1<T, Lazy<M1>> _function;

        public LazyModel1(IModel<M1> m1, Function1<T, Lazy<M1>> function) {
            super(function, m1);
            this._m1 = m1;
            this._function = function;
        }

        protected T load() {
            return this._function.apply(Transformator.lazy(this._m1));
        }
    }

    static final class Model3<T, M1, M2, M3>
    extends Transformator<T> {
        IModel<M1> _m1;
        IModel<M2> _m2;
        IModel<M3> _m3;
        Function3<T, M1, M2, M3> _function;

        public Model3(IModel<M1> m1, IModel<M2> m2, IModel<M3> m3, Function3<T, M1, M2, M3> function) {
            super(function, m1, m2, m3);
            this._m1 = m1;
            this._m2 = m2;
            this._m3 = m3;
            this._function = function;
        }

        protected T load() {
            return this._function.apply(this._m1.getObject(), this._m2.getObject(), this._m3.getObject());
        }
    }

    static final class Model2<T, M1, M2>
    extends Transformator<T> {
        IModel<M1> _m1;
        IModel<M2> _m2;
        Function2<T, M1, M2> _function;

        public Model2(IModel<M1> m1, IModel<M2> m2, Function2<T, M1, M2> function) {
            super(function, m1, m2);
            this._m1 = m1;
            this._m2 = m2;
            this._function = function;
        }

        protected T load() {
            return this._function.apply(this._m1.getObject(), this._m2.getObject());
        }
    }

    static final class Model1<T, M1>
    extends Transformator<T> {
        IModel<M1> _m1;
        Function1<T, M1> _function;

        public Model1(IModel<M1> m1, Function1<T, M1> function) {
            super(function, m1);
            this._m1 = m1;
            this._function = function;
        }

        protected T load() {
            return this._function.apply(this._m1.getObject());
        }
    }
}

