/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.wicket.events;

import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.event.IEventSource;

public class Events {
    private Events() {
    }

    public static <T extends IEventSource & IEventSink> Source<T> from(T source) {
        return new Source<T>(source);
    }

    static class EventSinkWrapper<R>
    implements IEventSink {
        private final Class<? extends R> _replyType;
        private final IEventSink _parent;
        R _reply;

        public EventSinkWrapper(IEventSink parent, Class<? extends R> replyType) {
            this._parent = parent;
            this._replyType = replyType;
        }

        public R getReply() {
            return this._reply;
        }

        public void onEvent(IEvent<?> event) {
            Object payload = event.getPayload();
            if (this._replyType.isInstance(payload)) {
                this._reply = payload;
            }
            this._parent.onEvent(event);
        }
    }

    public static class SourceAndBroadcast<T extends IEventSource & IEventSink> {
        private final T _source;
        private final Broadcast _broadcast;

        public SourceAndBroadcast(T source, Broadcast broadcast) {
            this._source = source;
            this._broadcast = broadcast;
        }

        public <T> void send(T payload) {
            this._source.send((IEventSink)this._source, this._broadcast, payload);
        }

        public <T, R> R sendWithReply(T payload, Class<? extends R> replyType) {
            EventSinkWrapper<R> sinkWrapper = new EventSinkWrapper<R>((IEventSink)this._source, replyType);
            this._source.send(sinkWrapper, this._broadcast, payload);
            return sinkWrapper.getReply();
        }
    }

    public static class Source<T extends IEventSource & IEventSink> {
        private final T _source;

        public Source(T source) {
            this._source = source;
        }

        public SourceAndBroadcast<T> broadcast(Broadcast broadcast) {
            return new SourceAndBroadcast<T>(this._source, broadcast);
        }
    }
}

