package de.flapdoodle.reverse;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Transitions.TransitionVertex}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTransitionVertex.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableTransitionVertex.of()}.
 */
@Generated(from = "Transitions.TransitionVertex", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
final class ImmutableTransitionVertex implements Transitions.TransitionVertex {
  private final Transition<?> transition;

  private ImmutableTransitionVertex(Transition<?> transition) {
    this.transition = Objects.requireNonNull(transition, "transition");
  }

  private ImmutableTransitionVertex(ImmutableTransitionVertex original, Transition<?> transition) {
    this.transition = transition;
  }

  /**
   * @return The value of the {@code transition} attribute
   */
  @Override
  public Transition<?> transition() {
    return transition;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Transitions.TransitionVertex#transition() transition} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transition
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransitionVertex withTransition(Transition<?> value) {
    if (this.transition == value) return this;
    Transition<?> newValue = Objects.requireNonNull(value, "transition");
    return new ImmutableTransitionVertex(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTransitionVertex} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTransitionVertex
        && equalTo(0, (ImmutableTransitionVertex) another);
  }

  private boolean equalTo(int synthetic, ImmutableTransitionVertex another) {
    return transition.equals(another.transition);
  }

  /**
   * Computes a hash code from attributes: {@code transition}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + transition.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TransitionVertex} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TransitionVertex{"
        + "transition=" + transition
        + "}";
  }

  /**
   * Construct a new immutable {@code TransitionVertex} instance.
   * @param transition The value for the {@code transition} attribute
   * @return An immutable TransitionVertex instance
   */
  public static ImmutableTransitionVertex of(Transition<?> transition) {
    return new ImmutableTransitionVertex(transition);
  }

  /**
   * Creates an immutable copy of a {@link Transitions.TransitionVertex} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TransitionVertex instance
   */
  public static ImmutableTransitionVertex copyOf(Transitions.TransitionVertex instance) {
    if (instance instanceof ImmutableTransitionVertex) {
      return (ImmutableTransitionVertex) instance;
    }
    return ImmutableTransitionVertex.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTransitionVertex ImmutableTransitionVertex}.
   * <pre>
   * ImmutableTransitionVertex.builder()
   *    .transition(de.flapdoodle.reverse.Transition&amp;lt;?&amp;gt;) // required {@link Transitions.TransitionVertex#transition() transition}
   *    .build();
   * </pre>
   * @return A new ImmutableTransitionVertex builder
   */
  public static ImmutableTransitionVertex.Builder builder() {
    return new ImmutableTransitionVertex.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTransitionVertex ImmutableTransitionVertex}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Transitions.TransitionVertex", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_TRANSITION = 0x1L;
    private long initBits = 0x1L;

    private Transition<?> transition;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TransitionVertex} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Transitions.TransitionVertex instance) {
      Objects.requireNonNull(instance, "instance");
      transition(instance.transition());
      return this;
    }

    /**
     * Initializes the value for the {@link Transitions.TransitionVertex#transition() transition} attribute.
     * @param transition The value for transition 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder transition(Transition<?> transition) {
      this.transition = Objects.requireNonNull(transition, "transition");
      initBits &= ~INIT_BIT_TRANSITION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTransitionVertex ImmutableTransitionVertex}.
     * @return An immutable instance of TransitionVertex
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTransitionVertex build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTransitionVertex(null, transition);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TRANSITION) != 0) attributes.add("transition");
      return "Cannot build TransitionVertex, some of required attributes are not set " + attributes;
    }
  }
}
