/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse.edges;

import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.StateLookup;
import de.flapdoodle.reverse.TearDown;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.edges.ImmutableDerive;
import de.flapdoodle.reverse.naming.HasLabel;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Derive<S, D>
implements Transition<D>,
HasLabel {
    public abstract StateID<S> source();

    @Override
    public abstract StateID<D> destination();

    protected abstract Function<S, State<D>> action();

    @Override
    @Value.Default
    public String transitionLabel() {
        return "Derive";
    }

    @Override
    @Value.Lazy
    public Set<StateID<?>> sources() {
        return Collections.singleton(this.source());
    }

    @Override
    @Value.Auxiliary
    public State<D> result(StateLookup lookup) {
        return this.action().apply(lookup.of(this.source()));
    }

    public static <S, D> ImmutableDerive<S, D> of(StateID<S> source, StateID<D> dest, Function<S, State<D>> action) {
        return ImmutableDerive.builder().source(source).destination(dest).action(action).build();
    }

    public static <D> WithSource<D> given(StateID<D> source) {
        return new WithSource(source);
    }

    public static <D> WithSource<D> given(Class<D> sourceType) {
        return Derive.given(StateID.of(sourceType));
    }

    public static class WithSourceAndDestination<S, D> {
        private final StateID<S> source;
        private final StateID<D> destination;

        public WithSourceAndDestination(StateID<S> source, StateID<D> destination) {
            this.source = source;
            this.destination = destination;
        }

        public ImmutableDerive<S, D> deriveBy(Function<S, D> action) {
            return this.with(action.andThen(x$0 -> State.of(x$0, new TearDown[0])));
        }

        public ImmutableDerive<S, D> with(Function<S, State<D>> action) {
            return Derive.of(this.source, this.destination, action);
        }
    }

    public static class WithSource<S> {
        private final StateID<S> source;

        private WithSource(StateID<S> source) {
            this.source = source;
        }

        public <D> WithSourceAndDestination<S, D> state(StateID<D> destination) {
            return new WithSourceAndDestination<S, D>(this.source, destination);
        }

        public <D> WithSourceAndDestination<S, D> state(Class<D> destination) {
            return this.state(StateID.of(destination));
        }
    }
}

