package de.flapdoodle.reverse;

import de.flapdoodle.reverse.naming.HasLabel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

/**
 * Immutable implementation of {@link TransitionWalker.MappedWrapper}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMappedWrapper.builder()}.
 */
@Generated(from = "TransitionWalker.MappedWrapper", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
final class ImmutableMappedWrapper<T> extends TransitionWalker.MappedWrapper<T> {
  private final List<Listener> listener;
  private final TransitionMapping<T> transitionMapping;
  private final Set<StateID<?>> missingSources;
  private final DefaultDirectedGraph<Transitions.Vertex, DefaultEdge> graph;
  private final String transitionLabel;

  private ImmutableMappedWrapper(
      List<Listener> listener,
      TransitionMapping<T> transitionMapping,
      Set<StateID<?>> missingSources,
      DefaultDirectedGraph<Transitions.Vertex, DefaultEdge> graph,
      String transitionLabel) {
    this.listener = listener;
    this.transitionMapping = transitionMapping;
    this.missingSources = missingSources;
    this.graph = graph;
    this.transitionLabel = transitionLabel;
  }

  /**
   * @return The value of the {@code listener} attribute
   */
  @Override
  protected List<Listener> listener() {
    return listener;
  }

  /**
   * @return The value of the {@code transitionMapping} attribute
   */
  @Override
  protected TransitionMapping<T> transitionMapping() {
    return transitionMapping;
  }

  /**
   * @return The value of the {@code missingSources} attribute
   */
  @Override
  protected Set<StateID<?>> missingSources() {
    return missingSources;
  }

  /**
   * @return The value of the {@code graph} attribute
   */
  @Override
  protected DefaultDirectedGraph<Transitions.Vertex, DefaultEdge> graph() {
    return graph;
  }

  /**
   * @return The value of the {@code transitionLabel} attribute
   */
  @Override
  public String transitionLabel() {
    return transitionLabel;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TransitionWalker.MappedWrapper#listener() listener}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMappedWrapper<T> withListener(Listener... elements) {
    List<Listener> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableMappedWrapper<>(newValue, this.transitionMapping, this.missingSources, this.graph, this.transitionLabel);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TransitionWalker.MappedWrapper#listener() listener}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of listener elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMappedWrapper<T> withListener(Iterable<? extends Listener> elements) {
    if (this.listener == elements) return this;
    List<Listener> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableMappedWrapper<>(newValue, this.transitionMapping, this.missingSources, this.graph, this.transitionLabel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransitionWalker.MappedWrapper#transitionMapping() transitionMapping} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transitionMapping
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMappedWrapper<T> withTransitionMapping(TransitionMapping<T> value) {
    if (this.transitionMapping == value) return this;
    TransitionMapping<T> newValue = Objects.requireNonNull(value, "transitionMapping");
    return new ImmutableMappedWrapper<>(this.listener, newValue, this.missingSources, this.graph, this.transitionLabel);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TransitionWalker.MappedWrapper#missingSources() missingSources}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableMappedWrapper<T> withMissingSources(StateID<?>... elements) {
    Set<StateID<?>> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableMappedWrapper<>(this.listener, this.transitionMapping, newValue, this.graph, this.transitionLabel);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TransitionWalker.MappedWrapper#missingSources() missingSources}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of missingSources elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMappedWrapper<T> withMissingSources(Iterable<? extends StateID<?>> elements) {
    if (this.missingSources == elements) return this;
    Set<StateID<?>> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return new ImmutableMappedWrapper<>(this.listener, this.transitionMapping, newValue, this.graph, this.transitionLabel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransitionWalker.MappedWrapper#graph() graph} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for graph
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMappedWrapper<T> withGraph(DefaultDirectedGraph<Transitions.Vertex, DefaultEdge> value) {
    if (this.graph == value) return this;
    DefaultDirectedGraph<Transitions.Vertex, DefaultEdge> newValue = Objects.requireNonNull(value, "graph");
    return new ImmutableMappedWrapper<>(this.listener, this.transitionMapping, this.missingSources, newValue, this.transitionLabel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransitionWalker.MappedWrapper#transitionLabel() transitionLabel} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transitionLabel
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMappedWrapper<T> withTransitionLabel(String value) {
    String newValue = Objects.requireNonNull(value, "transitionLabel");
    if (this.transitionLabel.equals(newValue)) return this;
    return new ImmutableMappedWrapper<>(this.listener, this.transitionMapping, this.missingSources, this.graph, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMappedWrapper} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMappedWrapper<?>
        && equalTo((ImmutableMappedWrapper<?>) another);
  }

  private boolean equalTo(ImmutableMappedWrapper<?> another) {
    return listener.equals(another.listener)
        && transitionMapping.equals(another.transitionMapping)
        && missingSources.equals(another.missingSources)
        && graph.equals(another.graph)
        && transitionLabel.equals(another.transitionLabel);
  }

  /**
   * Computes a hash code from attributes: {@code listener}, {@code transitionMapping}, {@code missingSources}, {@code graph}, {@code transitionLabel}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + listener.hashCode();
    h += (h << 5) + transitionMapping.hashCode();
    h += (h << 5) + missingSources.hashCode();
    h += (h << 5) + graph.hashCode();
    h += (h << 5) + transitionLabel.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MappedWrapper} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MappedWrapper{"
        + "listener=" + listener
        + ", transitionMapping=" + transitionMapping
        + ", missingSources=" + missingSources
        + ", graph=" + graph
        + ", transitionLabel=" + transitionLabel
        + "}";
  }

  private transient volatile long lazyInitBitmap;

  private static final long DESTINATION_LAZY_INIT_BIT = 0x1L;

  private transient StateID<T> destination;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link TransitionWalker.MappedWrapper#destination() destination} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code destination} attribute
   */
  @Override
  public StateID<T> destination() {
    if ((lazyInitBitmap & DESTINATION_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & DESTINATION_LAZY_INIT_BIT) == 0) {
          this.destination = Objects.requireNonNull(super.destination(), "destination");
          lazyInitBitmap |= DESTINATION_LAZY_INIT_BIT;
        }
      }
    }
    return destination;
  }

  private static final long SOURCES_LAZY_INIT_BIT = 0x2L;

  private transient Set<StateID<?>> sources;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link TransitionWalker.MappedWrapper#sources() sources} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code sources} attribute
   */
  @Override
  public Set<StateID<?>> sources() {
    if ((lazyInitBitmap & SOURCES_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SOURCES_LAZY_INIT_BIT) == 0) {
          this.sources = Objects.requireNonNull(super.sources(), "sources");
          lazyInitBitmap |= SOURCES_LAZY_INIT_BIT;
        }
      }
    }
    return sources;
  }

  /**
   * Creates an immutable copy of a {@link TransitionWalker.MappedWrapper} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable MappedWrapper instance
   */
  public static <T> ImmutableMappedWrapper<T> copyOf(TransitionWalker.MappedWrapper<T> instance) {
    if (instance instanceof ImmutableMappedWrapper<?>) {
      return (ImmutableMappedWrapper<T>) instance;
    }
    return ImmutableMappedWrapper.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMappedWrapper ImmutableMappedWrapper}.
   * <pre>
   * ImmutableMappedWrapper.&amp;lt;T&amp;gt;builder()
   *    .addListener|addAllListener(de.flapdoodle.reverse.Listener) // {@link TransitionWalker.MappedWrapper#listener() listener} elements
   *    .transitionMapping(de.flapdoodle.reverse.TransitionMapping&amp;lt;T&amp;gt;) // required {@link TransitionWalker.MappedWrapper#transitionMapping() transitionMapping}
   *    .addMissingSources|addAllMissingSources(de.flapdoodle.reverse.StateID&amp;lt;?&amp;gt;) // {@link TransitionWalker.MappedWrapper#missingSources() missingSources} elements
   *    .graph(org.jgrapht.graph.DefaultDirectedGraph&amp;lt;de.flapdoodle.reverse.Transitions.Vertex, org.jgrapht.graph.DefaultEdge&amp;gt;) // required {@link TransitionWalker.MappedWrapper#graph() graph}
   *    .transitionLabel(String) // required {@link TransitionWalker.MappedWrapper#transitionLabel() transitionLabel}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableMappedWrapper builder
   */
  public static <T> ImmutableMappedWrapper.Builder<T> builder() {
    return new ImmutableMappedWrapper.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableMappedWrapper ImmutableMappedWrapper}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TransitionWalker.MappedWrapper", generator = "Immutables")
  public static final class Builder<T> {
    private static final long INIT_BIT_TRANSITION_MAPPING = 0x1L;
    private static final long INIT_BIT_GRAPH = 0x2L;
    private static final long INIT_BIT_TRANSITION_LABEL = 0x4L;
    private long initBits = 0x7L;

    private List<Listener> listener = new ArrayList<Listener>();
    private TransitionMapping<T> transitionMapping;
    private List<StateID<?>> missingSources = new ArrayList<StateID<?>>();
    private DefaultDirectedGraph<Transitions.Vertex, DefaultEdge> graph;
    private String transitionLabel;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.reverse.TransitionWalker.MappedWrapper} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(TransitionWalker.MappedWrapper<T> instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.reverse.naming.HasLabel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(HasLabel instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    @SuppressWarnings("unchecked")
    private void from(Object object) {
      long bits = 0;
      if (object instanceof TransitionWalker.MappedWrapper<?>) {
        TransitionWalker.MappedWrapper<T> instance = (TransitionWalker.MappedWrapper<T>) object;
        addAllListener(instance.listener());
        transitionMapping(instance.transitionMapping());
        addAllMissingSources(instance.missingSources());
        if ((bits & 0x1L) == 0) {
          transitionLabel(instance.transitionLabel());
          bits |= 0x1L;
        }
        graph(instance.graph());
      }
      if (object instanceof HasLabel) {
        HasLabel instance = (HasLabel) object;
        if ((bits & 0x1L) == 0) {
          transitionLabel(instance.transitionLabel());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Adds one element to {@link TransitionWalker.MappedWrapper#listener() listener} list.
     * @param element A listener element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> addListener(Listener element) {
      this.listener.add(Objects.requireNonNull(element, "listener element"));
      return this;
    }

    /**
     * Adds elements to {@link TransitionWalker.MappedWrapper#listener() listener} list.
     * @param elements An array of listener elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> addListener(Listener... elements) {
      for (Listener element : elements) {
        this.listener.add(Objects.requireNonNull(element, "listener element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link TransitionWalker.MappedWrapper#listener() listener} list.
     * @param elements An iterable of listener elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> listener(Iterable<? extends Listener> elements) {
      this.listener.clear();
      return addAllListener(elements);
    }

    /**
     * Adds elements to {@link TransitionWalker.MappedWrapper#listener() listener} list.
     * @param elements An iterable of listener elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> addAllListener(Iterable<? extends Listener> elements) {
      for (Listener element : elements) {
        this.listener.add(Objects.requireNonNull(element, "listener element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link TransitionWalker.MappedWrapper#transitionMapping() transitionMapping} attribute.
     * @param transitionMapping The value for transitionMapping 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> transitionMapping(TransitionMapping<T> transitionMapping) {
      this.transitionMapping = Objects.requireNonNull(transitionMapping, "transitionMapping");
      initBits &= ~INIT_BIT_TRANSITION_MAPPING;
      return this;
    }

    /**
     * Adds one element to {@link TransitionWalker.MappedWrapper#missingSources() missingSources} set.
     * @param element A missingSources element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> addMissingSources(StateID<?> element) {
      this.missingSources.add(Objects.requireNonNull(element, "missingSources element"));
      return this;
    }

    /**
     * Adds elements to {@link TransitionWalker.MappedWrapper#missingSources() missingSources} set.
     * @param elements An array of missingSources elements
     * @return {@code this} builder for use in a chained invocation
     */
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder<T> addMissingSources(StateID<?>... elements) {
      for (StateID<?> element : elements) {
        this.missingSources.add(Objects.requireNonNull(element, "missingSources element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link TransitionWalker.MappedWrapper#missingSources() missingSources} set.
     * @param elements An iterable of missingSources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> missingSources(Iterable<? extends StateID<?>> elements) {
      this.missingSources.clear();
      return addAllMissingSources(elements);
    }

    /**
     * Adds elements to {@link TransitionWalker.MappedWrapper#missingSources() missingSources} set.
     * @param elements An iterable of missingSources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> addAllMissingSources(Iterable<? extends StateID<?>> elements) {
      for (StateID<?> element : elements) {
        this.missingSources.add(Objects.requireNonNull(element, "missingSources element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link TransitionWalker.MappedWrapper#graph() graph} attribute.
     * @param graph The value for graph 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> graph(DefaultDirectedGraph<Transitions.Vertex, DefaultEdge> graph) {
      this.graph = Objects.requireNonNull(graph, "graph");
      initBits &= ~INIT_BIT_GRAPH;
      return this;
    }

    /**
     * Initializes the value for the {@link TransitionWalker.MappedWrapper#transitionLabel() transitionLabel} attribute.
     * @param transitionLabel The value for transitionLabel 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> transitionLabel(String transitionLabel) {
      this.transitionLabel = Objects.requireNonNull(transitionLabel, "transitionLabel");
      initBits &= ~INIT_BIT_TRANSITION_LABEL;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMappedWrapper ImmutableMappedWrapper}.
     * @return An immutable instance of MappedWrapper
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMappedWrapper<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMappedWrapper<>(
          createUnmodifiableList(true, listener),
          transitionMapping,
          createUnmodifiableSet(missingSources),
          graph,
          transitionLabel);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TRANSITION_MAPPING) != 0) attributes.add("transitionMapping");
      if ((initBits & INIT_BIT_GRAPH) != 0) attributes.add("graph");
      if ((initBits & INIT_BIT_TRANSITION_LABEL) != 0) attributes.add("transitionLabel");
      return "Cannot build MappedWrapper, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }
}
