/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse;

import de.flapdoodle.graph.GraphAsDot;
import de.flapdoodle.graph.Graphs;
import de.flapdoodle.graph.ImmutableSubGraph;
import de.flapdoodle.reverse.ImmutableStateVertex;
import de.flapdoodle.reverse.ImmutableTransitionVertex;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.TransitionMapping;
import de.flapdoodle.reverse.TransitionWalker;
import de.flapdoodle.reverse.naming.HasLabel;
import de.flapdoodle.reverse.types.TypeNames;
import de.flapdoodle.types.Either;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.immutables.value.Value;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class Transitions {
    public static DefaultDirectedGraph<Vertex, DefaultEdge> asGraph(List<? extends Transition<?>> all) {
        Supplier directedGraph = Graphs.graphBuilder((Supplier)Graphs.directedGraph(DefaultEdge.class));
        return (DefaultDirectedGraph)Graphs.with((Supplier)directedGraph).build(graph -> all.forEach(edge -> {
            StateVertex destination = StateVertex.of(edge.destination());
            TransitionVertex transition = TransitionVertex.of(edge);
            graph.addVertex((Object)destination);
            graph.addVertex((Object)transition);
            graph.addEdge((Object)transition, (Object)destination);
            edge.sources().forEach(source -> {
                StateVertex s = StateVertex.of(source);
                graph.addVertex((Object)s);
                graph.addEdge((Object)s, (Object)transition);
            });
        }));
    }

    public static String edgeGraphAsDot(String label, DefaultDirectedGraph<Vertex, DefaultEdge> graph) {
        return Transitions.edgeGraphAsDot(label, graph, Transitions::transitionAsLabel, Transitions::stateAsLabel);
    }

    public static String edgeGraphAsDot(String label, DefaultDirectedGraph<Vertex, DefaultEdge> graph, Function<Transition<?>, String> transitionAsLabel, Function<StateID<?>, String> stateIdAsLabel) {
        return GraphAsDot.builder(Transitions.asId()).subGraphIdSeparator("__").label(label).nodeAsLabel(t -> {
            Either<StateVertex, TransitionVertex> stateOrTransition = Transitions.asEither(t);
            return (String)stateOrTransition.mapLeft(StateVertex::stateId).mapLeft(stateIdAsLabel::apply).mapRight(TransitionVertex::transition).mapRight(transitionAsLabel::apply).map(Function.identity(), Function.identity());
        }).nodeAttributes(t -> {
            Either<StateVertex, TransitionVertex> stateOrTransition = Transitions.asEither(t);
            String shape = stateOrTransition.isLeft() ? "ellipse" : "rectangle";
            return Transitions.asMap("shape", shape);
        }).subGraph(t -> {
            Transition<?> transition;
            if (t instanceof TransitionVertex && (transition = ((TransitionVertex)t).transition()) instanceof TransitionWalker.MappedWrapper) {
                TransitionWalker.MappedWrapper wrapper = (TransitionWalker.MappedWrapper)transition;
                ImmutableSubGraph subGraph = GraphAsDot.SubGraph.of(wrapper.graph()).connections(Transitions.asSubGraphMap(wrapper.transitionMapping(), wrapper.missingSources())).build();
                return Optional.of(subGraph);
            }
            return Optional.empty();
        }).build().asDot(graph);
    }

    private static Map<? extends Vertex, ? extends Vertex> asSubGraphMap(TransitionMapping<?> transitionMapping, Set<StateID<?>> missingSources) {
        LinkedHashMap<StateVertex, StateVertex> ret = new LinkedHashMap<StateVertex, StateVertex>();
        missingSources.forEach(dest -> {
            StateID source = transitionMapping.sourceOf(dest);
            ret.put(StateVertex.of(source), StateVertex.of(dest));
        });
        ret.put(StateVertex.of(transitionMapping.destination().destination()), StateVertex.of(transitionMapping.destination().source()));
        return Collections.unmodifiableMap(ret);
    }

    private static String stateAsLabel(StateID<?> t) {
        return (t.name().isEmpty() ? "<empty>" : t.name()) + ":" + TypeNames.typeName(t.type());
    }

    private static String transitionAsLabel(Transition<?> route) {
        if (route instanceof HasLabel) {
            return ((HasLabel)((Object)route)).transitionLabel();
        }
        return TypeNames.typeName(route.getClass());
    }

    private static Map<String, String> asMap(String ... keyValues) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        if (keyValues.length % 2 != 0) {
            throw new IllegalArgumentException("parameter not modulo of 2");
        }
        for (int i = 0; i < keyValues.length; i += 2) {
            ret.put(keyValues[i], keyValues[i + 1]);
        }
        return ret;
    }

    private static Function<Vertex, String> asId() {
        LinkedHashMap typeCounter = new LinkedHashMap();
        LinkedHashMap transitionMap = new LinkedHashMap();
        return vertex -> (String)Transitions.asEither(vertex).mapLeft(StateVertex::stateId).mapLeft(type -> (type.name().isEmpty() ? "<empty>" : type.name()) + ":" + type.type().toString()).mapRight(TransitionVertex::transition).mapRight(transition -> {
            Integer number = (Integer)transitionMap.get(transition);
            if (number == null) {
                typeCounter.putIfAbsent(transition.getClass(), -1);
                number = (Integer)typeCounter.get(transition.getClass()) + 1;
                typeCounter.put(transition.getClass(), number);
                transitionMap.put(transition, number);
            }
            return transition.getClass().getName() + ":" + number;
        }).map(Function.identity(), Function.identity());
    }

    public static Either<StateVertex, TransitionVertex> asEither(Vertex vertex) {
        if (vertex instanceof StateVertex) {
            return Either.left((Object)((StateVertex)vertex));
        }
        if (vertex instanceof TransitionVertex) {
            return Either.right((Object)((TransitionVertex)vertex));
        }
        throw new IllegalArgumentException("unknown vertext type: " + vertex + "(" + vertex.getClass() + ")");
    }

    @Value.Immutable
    static interface TransitionVertex
    extends Vertex {
        @Value.Parameter
        public Transition<?> transition();

        public static TransitionVertex of(Transition<?> transition) {
            return ImmutableTransitionVertex.of(transition);
        }
    }

    @Value.Immutable
    static interface StateVertex
    extends Vertex {
        @Value.Parameter
        public StateID<?> stateId();

        public static StateVertex of(StateID<?> stateId) {
            return ImmutableStateVertex.of(stateId);
        }
    }

    static interface Vertex {
    }
}

