/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.graph.Graphs;
import de.flapdoodle.graph.Loop;
import de.flapdoodle.graph.VerticesAndEdges;
import de.flapdoodle.reverse.ImmutableMappedWrapper;
import de.flapdoodle.reverse.Listener;
import de.flapdoodle.reverse.MapBasedStateLookup;
import de.flapdoodle.reverse.NamedTypeAndState;
import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.StateLookup;
import de.flapdoodle.reverse.TearDown;
import de.flapdoodle.reverse.TearDownException;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.TransitionMapping;
import de.flapdoodle.reverse.Transitions;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class TransitionWalker {
    private static final String JAVA_LANG_PACKAGE = "java.lang.";
    private final DefaultDirectedGraph<Transitions.Vertex, DefaultEdge> graph;

    private TransitionWalker(DefaultDirectedGraph<Transitions.Vertex, DefaultEdge> graph) {
        this.graph = graph;
    }

    private static Map<StateID<?>, State<?>> resolve(List<Transition<?>> transitions, Set<StateID<?>> destinations, StateLookup stateOfType, List<Listener> initListener) {
        LinkedHashMap ret = new LinkedHashMap();
        for (Transition<?> transition : transitions) {
            if (!destinations.contains(transition.destination())) continue;
            State<?> newState = TransitionWalker.resolve(stateOfType, initListener, transition);
            ret.put(transition.destination(), newState);
        }
        return ret;
    }

    private static <T> State<T> resolve(StateLookup stateOfType, List<Listener> initListener, Transition<T> transition) {
        State state = transition.result(stateOfType.limitedTo(transition.sources()));
        initListener.forEach(listener -> listener.onStateReached(transition.destination(), state.value()));
        return state;
    }

    public <D> ReachedState<D> initState(StateID<D> destination, Listener ... listener) {
        return this.initState(new LinkedHashMap(), destination, Collections.unmodifiableList(Arrays.asList(listener)));
    }

    public <D> Transition<D> asTransitionTo(TransitionMapping<D> mapping, Listener ... listener) {
        Transitions.StateVertex destination = Transitions.StateVertex.of(mapping.destination().source());
        Preconditions.checkArgument((boolean)this.graph.containsVertex((Object)destination), (String)"state %s is not part of this init process", (Object[])new Object[]{TransitionWalker.asMessage(mapping.destination().source())});
        Collection<VerticesAndEdges<Transitions.Vertex, DefaultEdge>> dependencies = TransitionWalker.dependenciesOf(this.graph, destination);
        Set<StateID<?>> sources = TransitionWalker.missingSources(dependencies, new LinkedHashMap());
        return ImmutableMappedWrapper.builder().graph(this.graph).transitionMapping(mapping).addListener(listener).addAllMissingSources(sources).build();
    }

    private <D> ReachedState<D> initState(Map<StateID<?>, State<?>> currentStateMap, StateID<D> dest, List<Listener> initListener) {
        Preconditions.checkArgument((!currentStateMap.containsKey(dest) ? 1 : 0) != 0, (String)"state %s already initialized", (Object[])new Object[]{TransitionWalker.asMessage(dest)});
        Transitions.StateVertex destination = Transitions.StateVertex.of(dest);
        Preconditions.checkArgument((boolean)this.graph.containsVertex((Object)destination), (String)"state %s is not part of this init process", (Object[])new Object[]{TransitionWalker.asMessage(dest)});
        LinkedHashMap stateMap = new LinkedHashMap(currentStateMap);
        ArrayList initializedStates = new ArrayList();
        Collection<VerticesAndEdges<Transitions.Vertex, DefaultEdge>> dependencies = TransitionWalker.dependenciesOf(this.graph, destination);
        if (!dependencies.isEmpty()) {
            Set<StateID<?>> missingSources = TransitionWalker.missingSources(dependencies, currentStateMap);
            Preconditions.checkArgument((boolean)missingSources.isEmpty(), (String)"missing transitions: %s", (Object[])new Object[]{TransitionWalker.asMessage(missingSources)});
        }
        for (VerticesAndEdges<Transitions.Vertex, DefaultEdge> set : dependencies) {
            List<Transition<?>> transitions = set.vertices().stream().filter(it -> it instanceof Transitions.TransitionVertex).map(it -> (Transitions.TransitionVertex)it).map(Transitions.TransitionVertex::transition).collect(Collectors.toList());
            Set destinations = transitions.stream().map(Transition::destination).collect(Collectors.toSet());
            Set<StateID<?>> needInitialization = TransitionWalker.filterNotIn(stateMap.keySet(), destinations);
            try {
                Map<StateID<?>, State<?>> newStatesAsMap = TransitionWalker.resolve(transitions, needInitialization, new MapBasedStateLookup(stateMap), initListener);
                if (newStatesAsMap.isEmpty()) continue;
                initializedStates.add(TransitionWalker.asNamedTypeAndState(newStatesAsMap));
                stateMap.putAll(newStatesAsMap);
            }
            catch (RuntimeException ex) {
                TransitionWalker.tearDown(initializedStates, initListener);
                throw new RuntimeException("error on transition to " + TransitionWalker.asMessage(needInitialization) + ", rollback", ex);
            }
        }
        return new ReachedState(this, initializedStates, stateMap, TransitionWalker.stateOfMap(stateMap, dest), initListener);
    }

    private static Set<StateID<?>> missingSources(Collection<VerticesAndEdges<Transitions.Vertex, DefaultEdge>> dependencies, Map<StateID<?>, State<?>> currentStateMap) {
        return dependencies.stream().findFirst().map(VerticesAndEdges::vertices).orElse(Collections.emptySet()).stream().filter(it -> it instanceof Transitions.StateVertex).map(it -> ((Transitions.StateVertex)it).stateId()).filter(it -> !currentStateMap.containsKey(it)).collect(Collectors.toSet());
    }

    private static Collection<VerticesAndEdges<Transitions.Vertex, DefaultEdge>> dependenciesOf(DefaultDirectedGraph<Transitions.Vertex, DefaultEdge> routesAsGraph, Transitions.StateVertex destination) {
        DefaultDirectedGraph filtered = Graphs.filter(routesAsGraph, v -> v.equals(destination) || TransitionWalker.isDependencyOf(routesAsGraph, v, destination));
        Collection roots = Graphs.rootsOf((DefaultDirectedGraph)filtered);
        return roots;
    }

    private static boolean isDependencyOf(DefaultDirectedGraph<Transitions.Vertex, DefaultEdge> routesAsGraph, Transitions.Vertex source, Transitions.StateVertex destination) {
        GraphPath ret = DijkstraShortestPath.findPathBetween(routesAsGraph, (Object)source, (Object)destination);
        return ret != null && !ret.getEdgeList().isEmpty();
    }

    private static <D> State<D> stateOfMap(Map<StateID<?>, State<?>> stateMap, StateID<D> destination) {
        return stateMap.get(destination);
    }

    private static void tearDown(List<Collection<NamedTypeAndState<?>>> initializedStates, List<Listener> initListener) {
        ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
        ArrayList copy = new ArrayList(initializedStates);
        Collections.reverse(copy);
        copy.forEach((Consumer<Collection<NamedTypeAndState<?>>>)((Consumer<Collection>)stateSet -> stateSet.forEach(typeAndState -> {
            TransitionWalker.notifyListener(initListener, typeAndState);
            try {
                TransitionWalker.tearDown(typeAndState.state());
            }
            catch (RuntimeException rx) {
                exceptions.add(rx);
            }
        })));
        if (!exceptions.isEmpty()) {
            if (exceptions.size() == 1) {
                throw new TearDownException("tearDown errors", (RuntimeException)exceptions.get(0));
            }
            throw new TearDownException("tearDown errors", exceptions);
        }
    }

    private static Collection<NamedTypeAndState<?>> asNamedTypeAndState(Map<StateID<?>, State<?>> newStatesAsMap) {
        return newStatesAsMap.entrySet().stream().map(TransitionWalker::namedTypeAndStateOf).collect(Collectors.toList());
    }

    private static NamedTypeAndState<?> namedTypeAndStateOf(Map.Entry<StateID<?>, State<?>> e) {
        return NamedTypeAndState.of(e.getKey(), e.getValue());
    }

    private static <T> void notifyListener(List<Listener> initListener, NamedTypeAndState<T> typeAndState) {
        initListener.forEach(listener -> listener.onStateTearDown(typeAndState.type(), typeAndState.state().value()));
    }

    private static <T> Set<T> filterNotIn(Set<T> existing, Set<T> toFilter) {
        return toFilter.stream().filter(t -> !existing.contains(t)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static <D> void tearDown(State<D> state) {
        state.onTearDown().ifPresent(t -> t.onTearDown(state.value()));
    }

    public static TransitionWalker with(List<? extends Transition<?>> src) {
        ArrayList routes = new ArrayList(src);
        String transitionWithCollisions = routes.stream().collect(Collectors.groupingBy(Transition::destination)).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> entry.getKey() + " --> " + entry.getValue()).collect(Collectors.joining(",\n  "));
        Preconditions.checkArgument((boolean)transitionWithCollisions.isEmpty(), (String)"multiple transitions with same destination: \n  %s", (Object[])new Object[]{transitionWithCollisions});
        DefaultDirectedGraph<Transitions.Vertex, DefaultEdge> graph = Transitions.asGraph(routes);
        List loops = Graphs.loopsOf(graph);
        Preconditions.checkArgument((boolean)loops.isEmpty(), (String)"loops are not supported: %s", (Object[])new Object[]{Preconditions.lazy(() -> TransitionWalker.asMessage(loops))});
        return new TransitionWalker(graph);
    }

    private static String asMessage(List<? extends Loop<Transitions.Vertex, DefaultEdge>> loops) {
        return loops.stream().map(TransitionWalker::asMessage).reduce((l, r) -> l + "\n" + r).orElse("");
    }

    private static String asMessage(Loop<Transitions.Vertex, DefaultEdge> loop) {
        return loop.vertexSet().stream().map(TransitionWalker::asMessage).reduce((l, r) -> l + "->" + r).get();
    }

    private static String asMessage(Collection<StateID<?>> types) {
        return types.stream().map(TransitionWalker::asMessage).reduce((l, r) -> l + ", " + r).orElse("");
    }

    private static String asMessage(Transitions.Vertex type) {
        return (String)Transitions.asEither(type).mapLeft(Transitions.StateVertex::stateId).mapLeft(TransitionWalker::asMessage).mapRight(Transitions.TransitionVertex::transition).mapRight(TransitionWalker::asMessage).map(Function.identity(), Function.identity());
    }

    private static String asMessage(StateID<?> type) {
        return "State(" + (type.name().isEmpty() ? TransitionWalker.typeAsMessage(type.type()) : type.name() + ":" + TransitionWalker.typeAsMessage(type.type())) + ")";
    }

    private static String asMessage(Transition<?> transition) {
        return transition.toString();
    }

    private static String typeAsMessage(Type type) {
        return type.getTypeName().startsWith(JAVA_LANG_PACKAGE) ? type.getTypeName().substring(JAVA_LANG_PACKAGE.length()) : type.getTypeName();
    }

    public static class ReachedState<D>
    implements AutoCloseable {
        private final State<D> state;
        private final List<Collection<NamedTypeAndState<?>>> initializedStates;
        private final Map<StateID<?>, State<?>> stateMap;
        private final TransitionWalker parent;
        private final List<Listener> initListener;

        private ReachedState(TransitionWalker parent, List<Collection<NamedTypeAndState<?>>> initializedStates, Map<StateID<?>, State<?>> stateMap, State<D> state, List<Listener> initListener) {
            this.parent = parent;
            this.state = state;
            this.initListener = (List)Preconditions.checkNotNull(initListener, (String)"initListener is null", (Object[])new Object[0]);
            this.stateMap = new LinkedHashMap(stateMap);
            this.initializedStates = new ArrayList(initializedStates);
        }

        public <T> ReachedState<T> initState(StateID<T> destination) {
            return this.parent.initState(this.stateMap, destination, this.initListener);
        }

        @Override
        public void close() {
            TransitionWalker.tearDown(this.initializedStates, this.initListener);
        }

        public D current() {
            return this.state.value();
        }

        public State<D> asState() {
            return State.builder(this.current()).onTearDown(current -> this.close()).build();
        }
    }

    @Value.Immutable
    static abstract class MappedWrapper<T>
    implements Transition<T> {
        MappedWrapper() {
        }

        protected abstract List<Listener> listener();

        protected abstract TransitionMapping<T> transitionMapping();

        protected abstract Set<StateID<?>> missingSources();

        protected abstract DefaultDirectedGraph<Transitions.Vertex, DefaultEdge> graph();

        @Override
        @Value.Lazy
        public StateID<T> destination() {
            return this.transitionMapping().destination().destination();
        }

        @Override
        @Value.Lazy
        public Set<StateID<?>> sources() {
            return this.missingSources().stream().map(this.transitionMapping()::sourceOf).collect(Collectors.toSet());
        }

        @Override
        @Value.Auxiliary
        public State<T> result(StateLookup lookup) {
            Map<StateID, State> stateMap = this.sources().stream().collect(Collectors.toMap(this.transitionMapping()::destinationOf, id -> State.of(lookup.of(id), new TearDown[0])));
            ReachedState reachedState = new TransitionWalker(this.graph()).initState(stateMap, this.transitionMapping().destination().source(), this.listener());
            return State.of(reachedState.current(), ignore -> reachedState.close());
        }
    }
}

